/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossdm.step;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliProcessOutputHandler
implements OverthereProcessOutputHandler {
    private final List<String> lines = new ArrayList<String>();
    private final List<String> errorLines = new ArrayList<String>();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void handleOutput(char c) {
    }

    public void handleOutputLine(String line) {
        if (Strings.isNullOrEmpty((String)line)) {
            return;
        }
        this.lines.add(line);
    }

    public void handleErrorLine(String line) {
        if (Strings.isNullOrEmpty((String)line)) {
            return;
        }
        this.errorLines.add(line);
    }

    public String getErrors() {
        return Joiner.on((String)"\n").join(this.errorLines);
    }

    public boolean hasErrors() {
        return !this.errorLines.isEmpty();
    }

    public Object getResult() {
        if (this.lines.isEmpty()) {
            return null;
        }
        if (this.lines.get(0).startsWith("{") && this.lines.get(this.lines.size() - 1).endsWith("}")) {
            return this.parseAsMap();
        }
        return Joiner.on((String)" ").join(this.lines);
    }

    private Map<String, Object> parseAsMap() {
        String jbon = Joiner.on((String)" ").join(this.lines);
        this.logger.trace("JBON: " + jbon);
        String json = ModelNode.fromString((String)jbon).toJSONString(true);
        this.logger.trace("JSON: " + json);
        try {
            return (Map)new ObjectMapper().readValue(json, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public String toString() {
        return "CliProcessOutputHandler{values=" + this.lines + "}";
    }
}

