import re

def getAppInstallName(name, type):
	ext = ".%s" % type
	if not name.endswith(ext):
		return name + ext
	return name

def undeploy(appName, serverGroup):
    isDeployed = False
    errMsg = ""
    if deployed.getProperty("deployToMultipleServerGroups"):
        if str(container.mode) == "DOMAIN":
            if str(container.type) == "jbossdm.ServerGroup":
                # remove war from server group
                errMsg = executeCmd("/server-group=%s/deployment=%s:remove" %(container.name, appName))
                if errMsg and resultFailed(errMsg):
                   logErrorAndExit(errMsg)
                serverGroups = executeCmd("ls  -l server-group")
                # undeploy war
                for group in serverGroups.split(' '):
                    logOutput("Checking server group %s" %(group))
                    if checkAddedToServerGroup(appName, group):
                        isDeployed = True

                if not isDeployed:
                    errMsg = executeCmd("undeploy %s" %(appName))
        else:
            errMsg = executeCmd("undeploy %s %s" % (appName, serverGroup))
    else:
        errMsg = executeCmd("undeploy %s %s" % (appName, serverGroup))

    if errMsg and resultFailed(errMsg):
        logErrorAndExit(errMsg)

def readDeploymentOnContainer(appName):
	if str(container.mode) == "DOMAIN":
		if str(container.type) == "jbossdm.ServerGroup":
			#Verify deployment exists for server group
			executeCmd("/server-group=%s/deployment=%s:read-resource()" %(container.name, appName))
		else:
			#Verify deployment exists on all  server groups in domain
			serverGroups = container.getProperty("serverGroups")
			for serverGroup in serverGroups:
				deployments = multiSpaceDelimitedLineToList(executeCmd("ls /server-group=%s/deployment" %(serverGroup.name)))
				if deployments.index(appName) == -1:
					logErrorAndExit("Inspection cannot be executed because %s is not deployed to all server groups for domain %s. Thus the deployed cannot be targeted to a Domain but to specific server groups instead." %(appName,container.name))

	return executeCmd("/deployment=%s:read-resource()" %(appName))

def checkDeploymentOnServerGroup(appName, commandString):
    if str(container.mode) == "DOMAIN":
        if str(container.type) == "jbossdm.ServerGroup":
            group = container.name
            if not checkDeploymentOnDomain(appName):
                commandString += " --server-groups=%s" %(group)
            else:
                if checkAddedToServerGroup(appName, group):
                    commandString = "/server-group=%s/deployment=%s:deploy" %(group, appName)
                else:
                    commandString = "/server-group=%s/deployment=%s:add(enabled=true)" %(group, appName)

    return commandString

def checkDeploymentOnDomain(appName):
    logOutput("Check deployed on domain %s" % (appName))
    deployment = executeCmd("ls -l deployment | grep %s" %(appName))
    logOutput("Checking %s exists in %s" %(appName, deployment))
    if not deployment is None and appName in deployment:
        return True

    return False

def checkAddedToServerGroup(appName, group):
    deployment = executeCmd("deployment info %s --server-group=%s | grep %s" %(appName, group, appName))
    if 'not added' in deployment.lower():
        return False

    return True

def resultFailed(result):
    if re.search("\{\s*\"outcome\"\s*=>\s*\"success\"", result):
        return False

    return True
