package com.xebialabs.deployit.plugin.jbossdm.container;

import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.jbossdm.controltask.ControlTaskDispatcher;
import com.xebialabs.deployit.plugin.overthere.Host;

import java.util.List;


@Metadata(description = "JBoss Server Group")
public class ServerGroup extends BaseContainer implements ApplicationContainer, CliManagedContainer {

    @Property(asContainment=true, description = "Domain to which the server group belongs.")
    private Domain domain;

    public List<Step> controlTaskDispatch(String name) {
        return ControlTaskDispatcher.dispatch(name, this);
    }

    @Override
    public CliManagingContainer getManagingContainer() {
        return domain;
    }

    @Override
    public String getTargetServerGroup(boolean undeployment) {
        return "--server-groups=" + getName();
    }

    @Override
    public Mode getMode() {
        return domain.getMode();
    }

    @Override
    public Host getHost() {
        return domain.getHost();
    }
}
