import sys
import re
from java.util import Map
from com.xebialabs.deployit.plugin.jbossdm.exception import CliScriptException

class CommandBuilder:
	def __init__(self, deployed, basicCmd):
		self.deployed = deployed
		self.cmd = basicCmd

	def add(self, prop, attr):
		propVal = self.deployed.getProperty(prop)
		if isinstance(propVal, bool):
			if propVal:
				propVal = "true"
			else:
				propVal = "false"
		self.cmd = "%s %s=%s" % (self.cmd, attr, str(propVal))
		return self

	def addIfNotBlank(self, prop, attr):
		propVal = self.deployed.getProperty(prop)
		if propVal and len(propVal.strip()) > 0:
			self.cmd = "%s %s=%s" % (self.cmd, attr, propVal)
		return self

	def addIfNotDefaultIntValue(self, prop, attr):
		propVal = self.deployed.getProperty(prop)
		if propVal > 0:
			self.cmd = "%s %s=%s" % (self.cmd, attr, propVal)
		return self

def logErrorAndExit(msg):
	logError(msg)
	raise CliScriptException(str(msg))


def logError(msg):
	step.ctx.logError(str(msg))

def logOutput(msg):
	step.ctx.logOutput(str(msg))

def executeCmd(cmd, exitOnFailure=True):
	try:
		r = step.executeCliCommand(cmd)
	except:
		logErrorAndExit("Failed to execute command. Error %s with message %s " % (sys.exc_info()[0], sys.exc_info()[1]))

	if exitOnFailure and r:
		if isinstance(r, Map):
			if r["outcome"] == "failed":
				logErrorAndExit(str(r["failure-description"]))
			elif len(r.keySet()) == 1:
				firstKey = r.keySet().iterator().next()
				print firstKey
				if firstKey.startswith('JBAS'):
					logErrorAndExit(str(r[firstKey]))
			elif not r.containsKey('outcome'):
				logErrorAndExit("Can not handle processing of object %s " % str(r))
		elif (re.match("^JBAS[0-9]+", r)):
			logErrorAndExit(r)

	return r

def uploadFile(file, targetName):
	return step.uploadToWorkingDirectory(file, targetName)

def targetServerGroups(undeployment=False):
	return container.getTargetServerGroup(undeployment)

def multiSpaceDelimitedLineToList(line):
	line = line.strip()
	values = []
	for token in line.split(" "):
		if len(token.strip()) > 0:
			values.append(token.strip())
	return values

def discovered(container, name, type):
	return step.discovered("%s/%s" % (container.id,name), type)

def prependProfilePath(cmd):
	if str(container.mode) == "DOMAIN":
		return "/profile=%s%s" %(container.profile, cmd)
	return cmd

def toString(propVal):
	if isinstance(propVal, bool):
		if propVal:
			propVal = "true"
		else:
			propVal = "false"
	else:
		propVal = str(propVal)
	return propVal


