class DatasourceBuilder:
	def __init__(self, deployed, jbossDs):
		self.deployed = deployed
		self.ds = jbossDs['result']

	def add(self, prop, attr):
		self.deployed.setProperty(prop, self.ds[attr])
		return self

	def addIfNotBlank(self, prop, attr):
		propVal = self.ds[attr]
		if propVal and len(propVal.strip()) > 0:
			self.deployed.setProperty(prop, propVal)
		return self

	def addIfNotDefaultIntValue(self, prop, attr):
		propVal = self.ds[attr]
		if propVal == None:
			self.deployed.setProperty(prop, -1)
		else:
			self.deployed.setProperty(prop, propVal)
		return self

# Utils
def inspectCommonDatasourceProperties(dsBuilder):
	dsBuilder.add('sharePreparedStatements', 'share-prepared-statements')
	dsBuilder.addIfNotDefaultIntValue('statementCacheSize',"prepared-statements-cache-size")
	dsBuilder.addIfNotBlank('username',"user-name")
	dsBuilder.addIfNotBlank('password',"password")
	dsBuilder.addIfNotBlank('jndiName',"jndi-name")
	dsBuilder.addIfNotBlank('driverName',"driver-name")
	dsBuilder.addIfNotBlank('securityDomain',"security-domain")
	dsBuilder.add('minPoolSize',"min-pool-size")
	dsBuilder.add('maxPoolSize',"max-pool-size")
	dsBuilder.add('strictMinimum',"pool-use-strict-min")
	dsBuilder.add('prefillEnabled',"pool-prefill")
	dsBuilder.addIfNotBlank('validConnectionChecker',"valid-connection-checker-class-name")
	dsBuilder.addIfNotBlank('checkValidSql',"check-valid-connection-sql")
	dsBuilder.add('validateOnMatch',"validate-on-match")
	dsBuilder.add('backgroundValidation',"background-validation")
	dsBuilder.addIfNotDefaultIntValue('validationMillis',"background-validation-millis")
	dsBuilder.addIfNotBlank('staleConnectionChecker',"stale-connection-checker-class-name")
	dsBuilder.addIfNotBlank('exceptionSorter',"exception-sorter-class-name")

def mapCommonDatasourceProperties(cmdBuilder):
	cmdBuilder.add('sharePreparedStatements',"--share-prepared-statements")
	cmdBuilder.addIfNotDefaultIntValue('statementCacheSize',"--prepared-statements-cache-size")
	cmdBuilder.addIfNotBlank('username',"--user-name")
	cmdBuilder.addIfNotBlank('password',"--password")
	cmdBuilder.addIfNotBlank('jndiName',"--jndi-name")
	cmdBuilder.addIfNotBlank('driverName',"--driver-name")
	cmdBuilder.addIfNotBlank('securityDomain',"--security-domain")
	cmdBuilder.add('minPoolSize',"--min-pool-size")
	cmdBuilder.add('maxPoolSize',"--max-pool-size")
	cmdBuilder.add('strictMinimum',"--pool-use-strict-min")
	cmdBuilder.add('prefillEnabled',"--pool-prefill")
	cmdBuilder.addIfNotBlank('validConnectionChecker',"--valid-connection-checker-class-name")
	cmdBuilder.addIfNotBlank('checkValidSql',"--check-valid-connection-sql")
	cmdBuilder.add('validateOnMatch',"--validate-on-match")
	cmdBuilder.add('backgroundValidation',"--background-validation")
	cmdBuilder.addIfNotDefaultIntValue('validationMillis',"--background-validation-millis")
	cmdBuilder.addIfNotBlank('staleConnectionChecker',"--stale-connection-checker-class-name")
	cmdBuilder.addIfNotBlank('exceptionSorter',"--exception-sorter-class-name")