package com.xebialabs.deployit.plugin.jbossdm.container;

import java.util.List;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.jbossdm.controltask.ControlTaskDispatcher;
import com.xebialabs.deployit.plugin.overthere.Host;


@Metadata(description = "JBoss Profile")
public class Profile extends BaseContainer implements ResourceContainer, CliManagedContainer {

    @Property(asContainment = true, description = "Domain to which the server group belongs.")
    private Domain domain;

    public List<Step> controlTaskDispatch(String name) {
        return ControlTaskDispatcher.dispatch(name, this);
    }

    @Override
    public CliManagingContainer getManagingContainer() {
        return domain;
    }

    @Override
    public String getProfile() {
        return getName();
    }

    @Override
    public Mode getMode() {
        return domain.getMode();
    }

    @Override
    public Host getHost() {
        return domain.getHost();
    }
}
