import re

class DatasourceBuilder:
  def __init__(self, deployed, jbossDs):
    self.deployed = deployed
    self.ds = jbossDs['result']

  def add(self, prop, attr):
    self.deployed.setProperty(prop, self.ds[attr])
    return self

  def addIfNotBlank(self, prop, attr):
    propVal = self.ds[attr]
    if propVal and len(propVal.strip()) > 0:
      self.deployed.setProperty(prop, propVal)
    return self

  def addIfNotDefaultIntValue(self, prop, attr):
    propVal = self.ds[attr]
    if propVal == None:
      self.deployed.setProperty(prop, -1)
    else:
      self.deployed.setProperty(prop, propVal)
    return self

# Utils
def inspectCommonDatasourceProperties(dsBuilder):
  dsBuilder.add('sharePreparedStatements', 'share-prepared-statements')
  dsBuilder.addIfNotDefaultIntValue('statementCacheSize',"prepared-statements-cache-size")
  dsBuilder.addIfNotBlank('username',"user-name")
  dsBuilder.addIfNotBlank('password',"password")
  dsBuilder.addIfNotBlank('jndiName',"jndi-name")
  dsBuilder.addIfNotBlank('driverName',"driver-name")
  dsBuilder.addIfNotBlank('securityDomain',"security-domain")
  dsBuilder.add('minPoolSize',"min-pool-size")
  dsBuilder.add('maxPoolSize',"max-pool-size")
  dsBuilder.add('strictMinimum',"pool-use-strict-min")
  dsBuilder.add('prefillEnabled',"pool-prefill")
  dsBuilder.addIfNotBlank('validConnectionChecker',"valid-connection-checker-class-name")
  dsBuilder.addIfNotBlank('checkValidSql',"check-valid-connection-sql")
  dsBuilder.add('validateOnMatch',"validate-on-match")
  dsBuilder.add('backgroundValidation',"background-validation")
  dsBuilder.addIfNotDefaultIntValue('validationMillis',"background-validation-millis")
  dsBuilder.addIfNotBlank('staleConnectionChecker',"stale-connection-checker-class-name")
  dsBuilder.addIfNotBlank('exceptionSorter',"exception-sorter-class-name")

def mapCommonDatasourceProperties(cmdBuilder):
  cmdBuilder.add('sharePreparedStatements',"--share-prepared-statements")
  cmdBuilder.addIfNotDefaultIntValue('statementCacheSize',"--prepared-statements-cache-size")
  cmdBuilder.addIfNotBlank('username',"--user-name")
  cmdBuilder.addIfNotBlank('password',"--password")
  cmdBuilder.addIfNotBlank('jndiName',"--jndi-name")
  cmdBuilder.addIfNotBlank('driverName',"--driver-name")
  cmdBuilder.addIfNotBlank('securityDomain',"--security-domain")
  cmdBuilder.add('minPoolSize',"--min-pool-size")
  cmdBuilder.add('maxPoolSize',"--max-pool-size")
  cmdBuilder.add('strictMinimum',"--pool-use-strict-min")
  cmdBuilder.add('prefillEnabled',"--pool-prefill")
  cmdBuilder.addIfNotBlank('validConnectionChecker',"--valid-connection-checker-class-name")
  cmdBuilder.addIfNotBlank('checkValidSql',"--check-valid-connection-sql")
  cmdBuilder.add('validateOnMatch',"--validate-on-match")
  cmdBuilder.add('backgroundValidation',"--background-validation")
  cmdBuilder.addIfNotDefaultIntValue('validationMillis',"--background-validation-millis")
  cmdBuilder.addIfNotBlank('staleConnectionChecker',"--stale-connection-checker-class-name")
  cmdBuilder.addIfNotBlank('exceptionSorter',"--exception-sorter-class-name")

# this delegate presumes we're single threaded and depends on it
def runBatch(batch):
    def execute(*args, **kwargs):
        cmds = []
        def aggregateCmds(cmd):
            cmds.append(cmd)
        original = batch.func_globals['executeCmd']
        try:
            if (original):
                batch.func_globals['executeCmd'] = aggregateCmds
            executeCmd("batch")
            r = batch(*args, **kwargs)
            executeCmd("run-batch")
            batchResults = executeCmds(cmds, False)
            if debugCommandLoggingEnabled:
                logOutput("Batch results: %s" % batchResults)
            for batchResult in batchResults:
                if (batchResult and re.search("JBAS[0-9]+", batchResult)):
                    executeCmds(["discard-batch"])
                    logOutputAndExit("Failed to create XA datasource. Please see jboss/wildfly log files for details. Error message is: %s" % batchResult)
        finally:
            batch.func_globals['executeCmd'] = original
    return execute

def executeCmds(cmds, exitOnFailure=True):
    if debugCommandLoggingEnabled:
        logOutput("Executing commands:\n %s" % cmds)
    try:
        results = step.executeCliCommands(cmds)
    except:
        logOutputAndExit("Failed to execute commands. Error %s with message %s " % (sys.exc_info()[0], sys.exc_info()[1]))

    if debugCommandLoggingEnabled:
        logOutput("Results:\n %s " % (results))

    if exitOnFailure and results:
        for r in results:
            if isinstance(r, Map):
                if r["outcome"] == "failed":
                    logErrorAndExit(str(r["failure-description"]))
                elif len(r.keySet()) == 1:
                    firstKey = r.keySet().iterator().next()
                    print firstKey
                    if firstKey.startswith('JBAS'):
                        logErrorAndExit(str(r[firstKey]))
                elif not r.containsKey('outcome'):
                    logErrorAndExit("Can not handle processing of object %s " % str(r))
            elif r and (re.search("JBAS[0-9]+", r)):
                logErrorAndExit("Execution of commands %s failed with error: %s" % (cmds, r))
    return results


def isXaDataSourceEnabled(name):
  isEnabledCmd = "/subsystem=datasources/xa-data-source=%s:read-attribute(name=enabled)" % (name)
  isEnabledCmd = prependProfilePath(isEnabledCmd)
  isEnabled = executeCmd(isEnabledCmd)["result"]
  return isEnabled

def isDataSourceEnabled(name):
  isEnabledCmd = "/subsystem=datasources/data-source=%s:read-attribute(name=enabled)" % (name)
  isEnabledCmd = prependProfilePath(isEnabledCmd)
  isEnabled = executeCmd(isEnabledCmd)["result"]
  return isEnabled


def validateDataSource(deployed):
    print "Validating datasource '%s'" % deployed.id
    if re.search(r"\s", deployed.name):
        logErrorAndExit("Deployed name must not contain space, but '%s' contains space." % (deployed.name))
