/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossdm.container;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.jbossdm.container.ApplicationContainer;
import com.xebialabs.deployit.plugin.jbossdm.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.jbossdm.container.CliManagingContainer;
import com.xebialabs.deployit.plugin.jbossdm.container.CommandExecutionMode;
import com.xebialabs.deployit.plugin.jbossdm.container.ResourceContainer;
import com.xebialabs.deployit.plugin.jbossdm.controltask.ControlTaskDispatcher;
import com.xebialabs.deployit.plugin.jbossdm.step.CliDaemon;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.RuntimeIOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="JBoss Cli Managed Container")
public abstract class CliBasedContainer
extends BaseContainer
implements ApplicationContainer,
ResourceContainer,
CliManagedContainer,
CliManagingContainer {
    @Property(asContainment=true)
    @InspectionProperty
    private Host host;
    @Property(description="JBoss home directory")
    @InspectionProperty
    private String home;
    @Property(required=false, defaultValue="9999", label="Administrative port", description="TCP port which is used to login to JBoss Native Administration, default is 9999")
    @InspectionProperty(required=false)
    private int port;
    @Property(required=false, defaultValue="true", description="Connection to CLI is setup using a daemon. Set it to false if connection to the host does not support streaming.")
    @InspectionProperty(required=false)
    private boolean enableDaemon;
    @Property(required=false, defaultValue="CLI_COMMANDS", description="Command execution mode when daemon is disabled. Commands can be executed directly against remote jboss CLI process using --commands option (CLI_COMMANDS) or they can be uploaded to a temporary file and executed using --file option (CLI_FILE). By default it is set to CLI_COMMANDS, but if you have special characters like '{}[]=@()' set it to the CLI_FILE value")
    @InspectionProperty(required=false)
    private CommandExecutionMode commandExecutionMode;
    @Property(required=false, defaultValue="localhost", label="Administrative Host", description="Host which is used to login to JBoss Native Administration, default is localhost")
    @InspectionProperty(required=false)
    private String adminHostAddress;
    @Property(required=false, label="Administrative username", description="Username which is used to login to JBoss Native Administration.")
    @InspectionProperty(required=false)
    private String username;
    @Property(required=false, password=true, label="Administrative password", description="Password which is used to login to JBoss Native Administration.")
    @InspectionProperty(required=false)
    private String password;
    @Property(defaultValue="jboss-cli", description="JBoss CLI script prefix. Depending on the host, either an '.sh' or '.bat' will be appended to get the cli script name.")
    @InspectionProperty(required=false)
    private String cliScriptPrefix;
    @Property(hidden=true, required=false, description="List of python library scripts that should be automatically loaded when using a JBoss CLI script.")
    private List<String> libraries = Lists.newArrayList();
    private static Logger LOG = LoggerFactory.getLogger(CliBasedContainer.class);

    public Host getHost() {
        return this.host;
    }

    @Override
    public String getCliExecutable() {
        OperatingSystemFamily os = this.host.getOs();
        return this.getHome() + os.getFileSeparator() + "bin" + os.getFileSeparator() + this.getCliScriptPrefix() + os.getScriptExtension();
    }

    public void setHost(Host host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getAdminHostAddress() {
        return this.adminHostAddress;
    }

    public void setAdminHostAddress(String adminHostAddress) {
        this.adminHostAddress = adminHostAddress;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCliScriptPrefix() {
        return this.cliScriptPrefix;
    }

    public void setCliScriptPrefix(String cliScriptPrefix) {
        this.cliScriptPrefix = cliScriptPrefix;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    @Override
    public List<String> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<String> libraries) {
        this.libraries = libraries;
    }

    @Override
    public CliManagingContainer getManagingContainer() {
        return this;
    }

    @Override
    public List<Object> execute(ExecutionContext ctx, String[] cmds) {
        String attrName = "managingContainersDaemon_" + this.getId();
        LOG.debug("CLIDAEMON: Using container under: {} to execute command.", (Object)attrName);
        CliDaemon daemon = (CliDaemon)ctx.getAttribute(attrName);
        if (daemon == null) {
            LOG.debug("CLIDAEMON: creating CliDaemon under {}", (Object)attrName);
            daemon = new CliDaemon(this.getCliExecutable(), this.getUsername(), this.getPassword(), this.getAdminHostAddress(), this.getPort(), this.getHost());
            ctx.setAttribute(attrName, (Object)daemon);
        }
        try {
            if (this.isEnableDaemon()) {
                return daemon.executeCliCommands(ctx, cmds);
            }
            switch (this.commandExecutionMode) {
                case CLI_FILE: {
                    return daemon.executeCliCommandsWithoutDaemonViaFile(ctx, cmds);
                }
            }
            return daemon.executeCliCommandsWithoutDaemon(ctx, cmds);
        }
        catch (RuntimeIOException e) {
            daemon.disconnect();
            ctx.setAttribute(attrName, null);
            throw e;
        }
    }

    @Override
    public Object execute(ExecutionContext ctx, String cmd) {
        String attrName = "managingContainersDaemon_" + this.getId();
        LOG.debug("CLIDAEMON: Using container under: {} to execute command.", (Object)attrName);
        CliDaemon daemon = (CliDaemon)ctx.getAttribute(attrName);
        if (daemon == null) {
            LOG.debug("CLIDAEMON: creating CliDaemon under {}", (Object)attrName);
            daemon = new CliDaemon(this.getCliExecutable(), this.getUsername(), this.getPassword(), this.getAdminHostAddress(), this.getPort(), this.getHost());
            ctx.setAttribute(attrName, (Object)daemon);
        }
        try {
            if (this.isEnableDaemon()) {
                return daemon.executeCliCommand(ctx, cmd);
            }
            switch (this.commandExecutionMode) {
                case CLI_FILE: {
                    return daemon.executeCliCommandsWithoutDaemonViaFile(ctx, new String[]{cmd});
                }
            }
            return daemon.executeCliCommandWithoutDaemon(ctx, cmd);
        }
        catch (RuntimeIOException e) {
            daemon.disconnect();
            ctx.setAttribute(attrName, null);
            throw e;
        }
    }

    public List<Step> controlTaskDispatch(String name) {
        return ControlTaskDispatcher.dispatch(name, this);
    }

    @Override
    public String getProfile() {
        return "default";
    }

    @Override
    public boolean isEnableDaemon() {
        return this.enableDaemon;
    }

    public void setEnableDaemon(boolean enableDaemon) {
        this.enableDaemon = enableDaemon;
    }

    public CommandExecutionMode getCommandExecutionMode() {
        return this.commandExecutionMode;
    }

    public void setCommandExecutionMode(CommandExecutionMode commandExecutionMode) {
        this.commandExecutionMode = commandExecutionMode;
    }
}

