/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossdm.step;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import com.google.common.reflect.Reflection;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.jbossdm.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.jbossdm.exception.CliScriptException;
import com.xebialabs.deployit.plugin.jbossdm.exception.CliScriptExit;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.python.core.Options;
import org.python.core.PyException;
import org.python.core.PySystemState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStep
implements PreviewStep {
    public static final String JYTHON_SCRIPT_ENGINE = "jython";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String script;
    private final int order;
    private final Map<String, Object> pythonContext;
    private String description;
    private CliManagedContainer container;
    private List<String> additionalLibraries = Lists.newArrayList();
    private String remoteWorkingDirPath;
    private boolean retainRemoteWorkingDirOnCompletion;
    private transient OverthereConnection localConn;
    private transient OverthereConnection remoteConn;
    private transient ExecutionContext ctx;
    private transient OverthereFile remoteWorkingDir;

    protected BaseStep(String script, int order, Map<String, Object> pythonContext, String description, CliManagedContainer container) {
        this.script = script;
        this.order = order;
        this.pythonContext = pythonContext;
        this.description = description;
        this.container = container;
    }

    public int getOrder() {
        return this.order;
    }

    public Preview getPreview() {
        try {
            StringBuilder builder = new StringBuilder();
            if (!this.additionalLibraries.isEmpty()) {
                for (String library : this.additionalLibraries) {
                    String script = Resources.toString((URL)Resources.getResource((String)library), (Charset)Charsets.UTF_8);
                    Preconditions.checkNotNull((Object)script, (String)"Library {} cannot be found on class path.", (Object[])new Object[]{library});
                    builder.append("\n\n#").append(library).append("\n").append(script);
                }
            }
            String scriptContent = Resources.toString((URL)Resources.getResource((String)this.script), (Charset)Charsets.UTF_8);
            builder.append("\n\n#").append(this.script).append("\n").append(scriptContent);
            return Preview.withSourcePathAndContents((String)this.script, (String)builder.toString());
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode handleExecute(ExecutionContext ctx) throws Exception {
        try {
            this.ctx = ctx;
            ScriptEngine scriptEngine = this.loadScriptEngine();
            this.executeScript(scriptEngine);
            StepExitCode stepExitCode = StepExitCode.SUCCESS;
            return stepExitCode;
        }
        finally {
            this.disconnect();
        }
    }

    protected void executeScript(ScriptEngine scriptEngine) throws IOException {
        Bindings bindings = this.createBindings(this.pythonContext);
        bindings.put("step", (Object)this);
        this.loadLibraryScriptsAndEval(this.script, scriptEngine, bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLibraryScriptsAndEval(String scriptPath, ScriptEngine scriptEngine, Bindings localBindings) throws IOException {
        String script = Resources.toString((URL)Resources.getResource((String)scriptPath), (Charset)Charsets.UTF_8);
        Bindings origEngineBindings = scriptEngine.getBindings(100);
        try {
            SimpleBindings engineAndLocalScope = new SimpleBindings();
            engineAndLocalScope.putAll(origEngineBindings);
            engineAndLocalScope.putAll(localBindings);
            scriptEngine.setBindings(engineAndLocalScope, 100);
            this.loadLibraryScripts(this.additionalLibraries, scriptEngine);
            this.logger.debug("Executing script " + scriptPath);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(script);
            }
            scriptEngine.eval(script);
        }
        catch (ScriptException e) {
            this.throwCliScriptException(scriptPath, e);
        }
        finally {
            scriptEngine.setBindings(origEngineBindings, 100);
        }
    }

    protected ScriptEngine loadScriptEngine() throws IOException {
        Options.includeJavaStackInExceptions = false;
        PySystemState engineState = new PySystemState();
        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName(JYTHON_SCRIPT_ENGINE);
        Preconditions.checkNotNull((Object)scriptEngine, (Object)"Jython Script Engine cannot be initialized. Make sure jython jars are on the class path.");
        this.loadLibraryScripts(this.container.getManagingContainer().getLibraries(), scriptEngine);
        return scriptEngine;
    }

    protected void loadLibraryScripts(List<String> libs, ScriptEngine scriptEngine) throws IOException {
        if (!libs.isEmpty()) {
            for (String library : libs) {
                String script = Resources.toString((URL)Resources.getResource((String)library), (Charset)Charsets.UTF_8);
                Preconditions.checkNotNull((Object)script, (String)"Library {} cannot be found on class path.", (Object[])new Object[]{library});
                try {
                    scriptEngine.eval(script);
                }
                catch (ScriptException e) {
                    this.throwCliScriptException(library, e);
                }
            }
        }
    }

    protected void throwCliScriptException(String scriptName, ScriptException e) {
        if (e.getCause() instanceof PyException) {
            this.handlePySyntaxError(scriptName, e);
        } else if (e.getMessage().startsWith(CliScriptExit.class.getName())) {
            this.handleCliScriptExit(scriptName, e);
        } else if (e.getMessage().startsWith("AttributeError:")) {
            this.handleAttributeError(scriptName, e);
        }
        throw new CliScriptException(scriptName, e);
    }

    private void handleCliScriptExit(String scriptName, ScriptException e) {
        String msg = e.getMessage().replaceAll(CliScriptExit.class.getName() + ":", "");
        msg = msg.replaceFirst("<script>", scriptName);
        if (e.getCause() instanceof PyException) {
            String stack = this.extractPyStack(scriptName, (PyException)e.getCause());
            throw new CliScriptExit(msg + "\n\n" + stack);
        }
        throw new CliScriptExit(msg);
    }

    private void handleAttributeError(String scriptName, ScriptException e) {
        String msg = e.getMessage();
        msg = msg.replaceFirst("<script>", scriptName);
        throw new CliScriptException(msg);
    }

    private void handlePySyntaxError(String scriptName, ScriptException e) {
        String msg = e.getCause().toString();
        msg = msg.replaceFirst("\"<script>\"", "\"" + scriptName + "\"");
        throw new CliScriptException(msg);
    }

    private String extractPyStack(String scriptName, PyException pyException) {
        StringBuilder stackBuffer = new StringBuilder();
        pyException.traceback.dumpStack(stackBuffer);
        String stack = stackBuffer.toString();
        stack = stack.replaceFirst("<script>", scriptName);
        return stack;
    }

    protected Bindings createBindings(Map<String, Object> variables) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.putAll((Map<? extends String, ? extends Object>)variables);
        for (String key : variables.keySet()) {
            Object obj = variables.get(key);
            if (!(obj instanceof Artifact)) continue;
            Artifact artifact = (Artifact)obj;
            String stagedKey = key + "_stagedFile";
            String autoUploadKey = stagedKey + "_AUTO_UPLOAD";
            boolean isArtifactFileStaged = variables.containsKey(stagedKey);
            boolean autoUploadEnabled = variables.containsKey(autoUploadKey);
            if (!isArtifactFileStaged || !autoUploadEnabled) continue;
            StagedFile stagedFile = (StagedFile)variables.get(stagedKey);
            OverthereConnection remoteConnection = this.getRemoteConnection();
            ExecutionContext executionContext = this.getCtx();
            ArtifactWrapper handler = new ArtifactWrapper(remoteConnection, executionContext, artifact, stagedFile);
            Artifact proxiedArtifact = (Artifact)Reflection.newProxy(Artifact.class, (InvocationHandler)handler);
            bindings.put(key, (Object)proxiedArtifact);
        }
        return bindings;
    }

    public Object executeCliCommand(String cmd) {
        return this.container.getManagingContainer().execute(this.ctx, cmd);
    }

    public List<Object> executeCliCommands(String[] cmds) {
        return this.container.getManagingContainer().execute(this.ctx, cmds);
    }

    public ExecutionContext getCtx() {
        return this.ctx;
    }

    public void setAdditionalLibraries(List<String> additionalLibraries) {
        this.additionalLibraries = additionalLibraries;
    }

    protected List<String> getAdditionalLibraries() {
        return this.additionalLibraries;
    }

    public CliManagedContainer getContainer() {
        return this.container;
    }

    public OverthereFile getRemoteWorkingDirectory() {
        if (this.remoteWorkingDir == null) {
            OverthereFile tempDir = Strings.isNullOrEmpty((String)this.getRemoteWorkingDirPath()) ? this.getRemoteConnection().getTempFile("jbossdm_plugin", ".tmp") : this.getRemoteConnection().getFile(this.getRemoteWorkingDirPath());
            tempDir.mkdir();
            this.remoteWorkingDir = tempDir;
        }
        return this.remoteWorkingDir;
    }

    public OverthereConnection getLocalConnection() {
        if (this.localConn == null) {
            this.localConn = LocalConnection.getLocalConnection();
        }
        return this.localConn;
    }

    public OverthereConnection getRemoteConnection() {
        if (this.remoteConn == null) {
            this.remoteConn = this.container.getManagingContainer().getHost().getConnection();
        }
        return this.remoteConn;
    }

    protected void disconnect() {
        if (this.localConn != null) {
            OverthereUtils.closeQuietly((Closeable)this.localConn);
        }
        if (!Strings.isNullOrEmpty((String)this.getRemoteWorkingDirPath()) && !this.isRetainRemoteWorkingDirOnCompletion()) {
            this.getRemoteWorkingDirectory().deleteRecursively();
        }
        if (this.remoteConn != null) {
            OverthereUtils.closeQuietly((Closeable)this.remoteConn);
        }
        this.remoteWorkingDir = null;
        this.localConn = null;
        this.remoteConn = null;
    }

    public String getRemoteWorkingDirPath() {
        return this.remoteWorkingDirPath;
    }

    public void setRemoteWorkingDirPath(String remoteWorkingDirPath) {
        this.remoteWorkingDirPath = remoteWorkingDirPath;
    }

    public boolean isRetainRemoteWorkingDirOnCompletion() {
        return this.retainRemoteWorkingDirOnCompletion;
    }

    public void setRetainRemoteWorkingDirOnCompletion(boolean deleteWorkingDirOnCompletion) {
        this.retainRemoteWorkingDirOnCompletion = deleteWorkingDirOnCompletion;
    }

    public OverthereFile uploadToWorkingDirectory(String content, String fileName) {
        this.getCtx().logOutput("Uploading file " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        OverthereUtils.write((byte[])content.getBytes(), (OverthereFile)target);
        return target;
    }

    public OverthereFile uploadToWorkingDirectory(File content, String fileName) {
        return this.uploadToWorkingDirectory(LocalFile.valueOf((File)content), fileName);
    }

    public OverthereFile uploadToWorkingDirectory(OverthereFile content, String fileName) {
        String fileType = content.isDirectory() ? "directory" : "file";
        this.getCtx().logOutput("Uploading " + fileType + " " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        content.copyTo(target);
        return target;
    }

    public OverthereFile uploadToWorkingDirectory(URL content, String fileName) {
        this.getCtx().logOutput("Uploading file " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        OutputStream out = target.getOutputStream();
        try {
            Resources.copy((URL)content, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        finally {
            OverthereUtils.closeQuietly((Closeable)out);
        }
        return target;
    }

    public boolean hostFileExists(String remoteFile) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteFile));
        OverthereFile file = this.getRemoteConnection().getFile(remoteFile);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readHostFile(String remoteFile) {
        String string;
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteFile));
        OverthereFile file = this.getRemoteConnection().getFile(remoteFile);
        Preconditions.checkArgument((boolean)file.exists(), (String)"File %s does not exist on host %s", (Object[])new Object[]{remoteFile, this.getContainer().getManagingContainer().getHost()});
        InputStream in = file.getInputStream();
        try {
            byte[] bytes = ByteStreams.toByteArray((InputStream)in);
            string = new String(bytes);
        }
        catch (Throwable throwable) {
            try {
                OverthereUtils.closeQuietly((Closeable)in);
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException("Failed to read file " + remoteFile, (Throwable)e);
            }
        }
        OverthereUtils.closeQuietly((Closeable)in);
        return string;
    }

    public String[] readHostFileLines(String remoteFile) {
        String data = this.readHostFile(remoteFile);
        Iterable iterable = Splitter.on((String)this.getContainer().getManagingContainer().getHost().getOs().getLineSeparator()).split((CharSequence)data);
        return (String[])Iterables.toArray((Iterable)iterable, String.class);
    }

    private static class ArtifactWrapper
    implements InvocationHandler {
        private Artifact target;
        private StagedFile stagedFile;
        private OverthereFile targetFile;
        private OverthereConnection remoteConnection;
        private ExecutionContext executionContext;

        ArtifactWrapper(OverthereConnection remoteConnection, ExecutionContext executionContext, Artifact artifact, StagedFile stagedFile) {
            this.remoteConnection = remoteConnection;
            this.executionContext = executionContext;
            this.target = artifact;
            this.stagedFile = stagedFile;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getFile".equals(method.getName())) {
                if (null == this.targetFile) {
                    this.targetFile = this.stagedFile.get(this.remoteConnection, this.executionContext);
                }
                return this.targetFile;
            }
            return method.invoke((Object)this.target, args);
        }
    }
}

