package com.xebialabs.deployit.plugin.jbossdm.container;

import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.jbossdm.step.CliInspectionStep;

import static com.google.common.collect.Maps.newHashMap;
import static com.google.common.collect.Sets.newHashSet;

@SuppressWarnings("serial")
@Metadata(inspectable = true)
public class Domain extends CliBasedContainer {

    @Property(required = false, asContainment = true, description = "Server groups defined in domain")
    private Set<ServerGroup> serverGroups = newHashSet();

    @Property(required = false, asContainment = true, description = "Profiles defined in domain")
    private Set<Profile> profiles = newHashSet();

    @Inspect
    public void inspect(InspectionContext ctx) {
        Map<String, Object> pyCtx = newHashMap();
        pyCtx.put("container", this);
        CliInspectionStep step = new CliInspectionStep("jboss/dm/container/inspect-domain.py", 0, pyCtx, "Inspect Domain", this);
        ctx.addStep(step);
    }

    @Override
    public String getTargetServerGroup(boolean undeployment) {
        if (undeployment) {
            return "--all-relevant-server-groups";
        }
        return "--all-server-groups";

    }

    public Set<ServerGroup> getServerGroups() {
        return serverGroups;
    }

    public void setServerGroups(Set<ServerGroup> serverGroups) {
        this.serverGroups = serverGroups;
    }


    public Set<Profile> getProfiles() {
        return profiles;
    }

    public void setProfiles(Set<Profile> profiles) {
        this.profiles = profiles;
    }

    @Override
    public Mode getMode() {
        return Mode.DOMAIN;
    }
}
