package com.xebialabs.deployit.plugin.jbossdm.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.jbossdm.container.CliManagedContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

@SuppressWarnings("serial")
public class CliInspectionStep extends BaseStep {

    protected static final Logger logger = LoggerFactory.getLogger(CliInspectionStep.class);

    public CliInspectionStep(String script, int order, Map<String, Object> pythonContext, String description, CliManagedContainer container) {
        super(script, order, pythonContext, description, container);
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return handleExecute(ctx);
    }

    @Override
    protected Logger logger() {
        return logger;
    }

    public ConfigurationItem discovered(String name, String type) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor(type);
        ConfigurationItem item = descriptor.newInstance(name);
        getCtx().getInspectionContext().discovered(item);
        getCtx().getInspectionContext().inspected(item);
        return item;
    }


}
