cmd = "/subsystem=datasources/xa-data-source=%s:read-resource" %(deployed.name)
cmd = prependProfilePath(cmd)
ds = executeCmd(cmd)

dsBuilder = DatasourceBuilder(deployed, ds)
inspectCommonDatasourceProperties(dsBuilder)

dsBuilder.addIfNotBlank('newConnectionSql',"new-connection-sql")
dsBuilder.addIfNotBlank('transactionIsolation',"transaction-isolation")
dsBuilder.add('sameRmOverride',"same-rm-override")
dsBuilder.add('interleave',"interleaving")
dsBuilder.add('padXid',"pad-xid")
dsBuilder.add('wrapXa',"wrap-xa-resource")

connPropPath = "/subsystem=datasources/xa-data-source=%s/xa-datasource-properties" % (deployed.name)
connPropPath = prependProfilePath(connPropPath)

connectionPropertyKeysCmd = 'ls %s' % (connPropPath)
connectionPropKeys = multiSpaceDelimitedLineToList(executeCmd(connectionPropertyKeysCmd))

connProps = deployed.getProperty("xaProperties")

for k in connectionPropKeys:
	valueCmd = '%s=%s:read-attribute(name=value)' % (connPropPath,k)
	value = executeCmd(valueCmd)
	connProps.put(k,value['result'])
