package com.xebialabs.deployit.plugin.jbossdm.step;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;

public class JustInTimeFile implements StagedFile {
    private static final Logger logger = LoggerFactory.getLogger(JustInTimeFile.class);

    private Artifact source;

    JustInTimeFile(Artifact artifact) {
        this.source = artifact;
    }

    @Override
    public OverthereFile get(OverthereConnection c, ExecutionContext ctx) {
        logger.debug("Creating temporary file for artifact [{}]", source.getName());
        String name = source.getFile().getName();
        OverthereFile uploadedFileArtifact = c.getTempFile(source.getFile().getName());
        ctx.logOutput(String.format("Uploading artifact [%s]", uploadedFileArtifact.getPath()));
        source.getFile().copyTo(uploadedFileArtifact);
        logger.debug("Uploaded artifact [{}]", uploadedFileArtifact.getPath());
        return uploadedFileArtifact;
    }

}
