import re
from com.xebialabs.deployit.plugin.jbossdm.overthere import CustomCmdLine

from java.util import List
import types

class DatasourceBuilder:
  def __init__(self, deployed, jbossDs):
    self.deployed = deployed
    self.ds = jbossDs['result']

  def add(self, prop, attr):
    self.deployed.setProperty(prop, self.ds[attr])
    return self

  def addIfNotBlank(self, prop, attr):
    propVal = self.ds[attr]
    if propVal and type(propVal) != unicode and type(propVal) != str:
        propVal = str(propVal)

    if propVal and len(propVal.strip()) > 0:
      self.deployed.setProperty(prop, propVal)
    return self

  def addIfNotDefaultIntValue(self, prop, attr):
    propVal = self.ds[attr]
    if propVal == None:
      self.deployed.setProperty(prop, -1)
    else:
      self.deployed.setProperty(prop, propVal)
    return self

# Utils
def inspectCommonDatasourceProperties(dsBuilder):
  dsBuilder.add('sharePreparedStatements', 'share-prepared-statements')
  dsBuilder.addIfNotDefaultIntValue('statementCacheSize',"prepared-statements-cache-size")
  dsBuilder.addIfNotBlank('username',"user-name")
  dsBuilder.addIfNotBlank('password',"password")
  dsBuilder.addIfNotBlank('jndiName',"jndi-name")
  dsBuilder.addIfNotBlank('driverName',"driver-name")
  dsBuilder.addIfNotBlank('securityDomain',"security-domain")
  dsBuilder.addIfNotBlank('minPoolSize',"min-pool-size")
  dsBuilder.addIfNotBlank('maxPoolSize',"max-pool-size")
  dsBuilder.add('strictMinimum',"pool-use-strict-min")
  dsBuilder.add('prefillEnabled',"pool-prefill")
  dsBuilder.addIfNotBlank('validConnectionChecker',"valid-connection-checker-class-name")
  dsBuilder.addIfNotBlank('checkValidSql',"check-valid-connection-sql")
  dsBuilder.add('validateOnMatch',"validate-on-match")
  dsBuilder.add('backgroundValidation',"background-validation")
  dsBuilder.addIfNotDefaultIntValue('validationMillis',"background-validation-millis")
  dsBuilder.addIfNotBlank('staleConnectionChecker',"stale-connection-checker-class-name")
  dsBuilder.addIfNotBlank('exceptionSorter',"exception-sorter-class-name")

def mapCommonDatasourceProperties(cmdBuilder):
  cmdBuilder.add('sharePreparedStatements',"--share-prepared-statements")
  cmdBuilder.addIfNotDefaultIntValue('statementCacheSize',"--prepared-statements-cache-size")
  cmdBuilder.addIfNotBlank('username',"--user-name")
  cmdBuilder.addIfNotBlank('password',"--password")
  cmdBuilder.addIfNotBlank('jndiName',"--jndi-name")
  cmdBuilder.addIfNotBlank('driverName',"--driver-name")
  cmdBuilder.addIfNotBlank('securityDomain',"--security-domain")
  cmdBuilder.add('minPoolSize',"--min-pool-size")
  cmdBuilder.add('maxPoolSize',"--max-pool-size")
  cmdBuilder.add('strictMinimum',"--pool-use-strict-min")
  cmdBuilder.add('prefillEnabled',"--pool-prefill")
  cmdBuilder.addIfNotBlank('validConnectionChecker',"--valid-connection-checker-class-name")
  cmdBuilder.addIfNotBlank('checkValidSql',"--check-valid-connection-sql")
  cmdBuilder.add('validateOnMatch',"--validate-on-match")
  cmdBuilder.add('backgroundValidation',"--background-validation")
  cmdBuilder.addIfNotDefaultIntValue('validationMillis',"--background-validation-millis")
  cmdBuilder.addIfNotBlank('staleConnectionChecker',"--stale-connection-checker-class-name")
  cmdBuilder.addIfNotBlank('exceptionSorter',"--exception-sorter-class-name")

# this delegate presumes we're single threaded and depends on it
def runBatch(batch):
    def resultHasErrors(batchResult):
        if isinstance(batchResult, List):
            for r in batchResult:
                if resultHasErrors(r):
                    return True
        elif isinstance(batchResult, Map):
            if "outcome" in batchResult and batchResult["outcome"] == "failed":
                return True
            elif len(batchResult.keySet()) == 1:
                firstKey = batchResult.keySet().iterator().next()
                if isErrorKey(firstKey):
                    return True
        elif batchResult:
            if isErrorResult(batchResult):
                return True
        else:
            return False

    def execute(*args, **kwargs):
        cmds = []
        def aggregateCmds(cmd):
            cmds.append(cmd)
        original = batch.func_globals['executeCmd']
        try:
            if (original):
                batch.func_globals['executeCmd'] = aggregateCmds
            executeCmd(CustomCmdLine.build("batch"))
            r = batch(*args, **kwargs)
            executeCmd(CustomCmdLine.build("run-batch"))
            batchResults = executeCmds(cmds, False)
            if debugCommandLoggingEnabled:
                logOutput("Batch results: %s" % batchResults)
            for batchResult in batchResults:
                if resultHasErrors(batchResult) == True:
                    executeCmds(["discard-batch"])
                    logOutputAndExit("Failed to create XA datasource. Please see jboss/wildfly log files for details. Error message is: %s" % batchResult)
        finally:
            batch.func_globals['executeCmd'] = original
    return execute

def executeCmds(cmds, exitOnFailure=True):
    if debugCommandLoggingEnabled:
        logOutput("Executing commands:\n %s" % cmds)
    try:
        results = step.executeCliCommands(cmds)
    except:
        logOutputAndExit("Failed to execute commands. Error %s with message %s " % (sys.exc_info()[0], sys.exc_info()[1]))

    if debugCommandLoggingEnabled:
        logOutput("Results:\n %s " % (results))

    if exitOnFailure and results:
        checkResultForErrors(results)
    return results


def isXaDataSourceEnabled(name):
  isEnabledCmd = "/subsystem=datasources/xa-data-source=%s:read-attribute(name=enabled)" % (name)
  isEnabledCmd = prependProfilePath(isEnabledCmd)
  res = executeCmd(isEnabledCmd)
  if isinstance(res, types.ListType) and len(res)==1:
      isEnabled = res[0]["result"]
  elif not isinstance(res, types.ListType):
      isEnabled = res["result"]
  else:
    logOutput("type is %s" % type(res))
  return isEnabled

def isDataSourceEnabled(name):
  isEnabledCmd = "/subsystem=datasources/data-source=%s:read-attribute(name=enabled)" % (name)
  isEnabledCmd = prependProfilePath(isEnabledCmd)
  res = executeCmd(isEnabledCmd)
  if isinstance(res, types.ListType) and len(res)==1:
      isEnabled = res[0]["result"]
  elif not isinstance(res, types.ListType):
      isEnabled = res["result"]
  else:
    logOutput("type is %s" % type(res))
  return isEnabled

def validateDataSource(deployed):
    print "Validating datasource '%s'" % deployed.id
    if re.search(r"\s", deployed.name):
        logErrorAndExit("Deployed name must not contain space, but '%s' contains space." % (deployed.name))
