/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.lock;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.repository.sql.CiLockRepositoryHolder;
import java.util.Collections;
import java.util.List;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, description="Manager for container locks")
public class Manager
extends BaseContainer {
    @ControlTask(description="Clears all locks")
    public List<Step> clearLocks() {
        Step clearLocksStep = new Step(){

            public String getDescription() {
                return "Clearing all locks";
            }

            public StepExitCode execute(ExecutionContext ec) {
                CiLockRepositoryHolder.getCiLockRepository().clearLocksByTaskId(ec.getTask().getId());
                return StepExitCode.SUCCESS;
            }

            public int getOrder() {
                return 0;
            }
        };
        return Collections.singletonList(clearLocksStep);
    }

    @ControlTask(description="Lists all locks")
    public List<Step> listLocks() {
        Step listLocksStep = new Step(){

            public String getDescription() {
                return "Listing all locks";
            }

            public StepExitCode execute(ExecutionContext ctx) {
                ctx.logOutput("The following CIs are currently locked:");
                List locksListing = CollectionConverters.asJava((Seq)CiLockRepositoryHolder.getCiLockRepository().listLocksByTaskId(ctx.getTask().getId()));
                if (locksListing.isEmpty()) {
                    ctx.logOutput("<none>");
                } else {
                    locksListing.forEach(ci -> ctx.logOutput("- " + ci));
                }
                return StepExitCode.SUCCESS;
            }

            public int getOrder() {
                return 0;
            }
        };
        return Collections.singletonList(listLocksStep);
    }
}

