/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.netscaler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Range;
import com.xebialabs.deployit.plugin.generic.step.WaitStep;
import com.xebialabs.deployit.plugin.lb.ci.LoadBalancer;
import com.xebialabs.deployit.plugin.netscaler.step.CliScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

@Metadata(root=Metadata.ConfigurationItemRoot.NESTED, virtual=false, description="A Citrix NetScaler LoadBalancer")
public class NetScaler
extends LoadBalancer {
    public static final String CONTAINER_NS_SHUTDOWN_DELAY = "netscalerShutdownDelay";
    private static final String CONTAINER_NS_ADDRESS = "netscalerAddress";
    @Property(defaultValue="8", hidden=true)
    private int disableServersOrder = 8;
    @Property(defaultValue="netscaler/disable-server.cli.ftl", hidden=true)
    private String disableServersScript = "netscaler/disable-server.cli.ftl";
    @Property(defaultValue="94", hidden=true)
    private int enableServersOrder = 94;
    @Property(defaultValue="netscaler/enable-server.cli.ftl", hidden=true)
    private String enableServersScript = "netscaler/enable-server.cli.ftl";
    @Property(required=false, description="The amount of seconds to wait before the servers are disabled in the load balancer", defaultValue="0")
    @Range(minimum=0)
    private int defaultShutdownDelay;
    @Property(asContainment=true)
    private Host host;

    public void stopTraffic(DeploymentPlanningContext ctx, Set<Container> serversToDisable) {
        this.validateAllServersHaveNetScalerAddress(serversToDisable);
        ctx.addStep((Step)new CliScriptExecutionStep(this.disableServersOrder, "source", this.disableServersScript, (HostContainer)this, this.createContext(serversToDisable), String.format("Disable servers %s in %s", new Object[]{serversToDisable, this})));
        ctx.addStep((Step)new WaitStep(this.disableServersOrder, this.determineMaxWait(serversToDisable), this.toString(), "disable servers"));
    }

    public void startTraffic(DeploymentPlanningContext ctx, Set<Container> serversToEnable) {
        this.validateAllServersHaveNetScalerAddress(serversToEnable);
        ctx.addStep((Step)new CliScriptExecutionStep(this.enableServersOrder, "source", this.enableServersScript, (HostContainer)this, this.createContext(serversToEnable), String.format("Enable servers %s in %s", new Object[]{serversToEnable, this})));
    }

    private Map<String, Object> createContext(Set<Container> servers) {
        return ImmutableMap.of((Object)"loadBalancer", (Object)((Object)this), (Object)"servers", servers);
    }

    @VisibleForTesting
    int determineMaxWait(Set<Container> servers) {
        int waitTime = 0;
        for (Container server : servers) {
            int serverTime = this.waitForServer(server);
            waitTime = serverTime > waitTime ? serverTime : waitTime;
        }
        return waitTime;
    }

    public int waitForServer(Container server) {
        int serverTime = (Integer)server.getProperty(CONTAINER_NS_SHUTDOWN_DELAY);
        if (serverTime < 0) {
            return this.defaultShutdownDelay;
        }
        return serverTime;
    }

    private void validateAllServersHaveNetScalerAddress(Collection<Container> servers) {
        for (Container server : servers) {
            this.serverAddress(server);
        }
    }

    public String serverAddress(Container server) {
        String serverAddress = (String)server.getProperty(CONTAINER_NS_ADDRESS);
        if (!Strings.nullToEmpty((String)serverAddress).trim().isEmpty()) {
            return serverAddress;
        }
        if (server.getType().instanceOf(Type.valueOf(HostContainer.class))) {
            return (String)((HostContainer)server).getHost().getProperty("address");
        }
        throw new IllegalStateException(String.format("Could not dermine netscaler Address for container [%s]", server));
    }

    public Host getHost() {
        return this.host;
    }

    public void setDefaultShutdownDelay(int defaultShutdownDelay) {
        this.defaultShutdownDelay = defaultShutdownDelay;
    }
}

