package com.xebialabs.deployit.plugin.netscaler.step;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;

import static com.google.common.io.Closeables.closeQuietly;
import static com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler.handleStderr;
import static com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler.handleStdout;

public class CliScriptExecutionStep extends ScriptExecutionStep {

    private String runCommand;

    public CliScriptExecutionStep(int order, String runCommand, String scriptPath, HostContainer container, Map<String, Object> vars, String description) {
        super(order, scriptPath, container, vars, description);
        this.runCommand = runCommand;
    }

    /**
     * Override of complete method from BaseExecutionStep, just to add the runCommand...
     * @param executable
     * @return
     */
    protected StepExitCode executeScript(OverthereFile executable) {
        executable.setExecutable(true);

        CmdLine cmdLine = CmdLine.build(runCommand, executable.getPath());
        DefaultExecutionOutputHandler stdoutHandler = handleStdout(getCtx());
        DefaultExecutionOutputHandler stderrHandler = handleStderr(getCtx());
        try {
            getCtx().logOutput("Executing " + executable.getPath() + " on host " + getContainer().getHost());
            int rc = getRemoteConnection().execute(stdoutHandler, stderrHandler, cmdLine);
            if (rc != 0) {
                getCtx().logError("Execution failed with return code " + rc);
                return StepExitCode.FAIL;
            }
            return StepExitCode.SUCCESS;
        } finally {
            closeQuietly(stdoutHandler);
            closeQuietly(stderrHandler);
        }
    }

}
