/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.netscaler.step;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;

public class CliScriptExecutionStep
extends ScriptExecutionStep {
    private String runCommand;

    public CliScriptExecutionStep(int order, String runCommand, String scriptPath, HostContainer container, Map<String, Object> vars, String description) {
        super(order, scriptPath, container, vars, description);
        this.runCommand = runCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StepExitCode executeScript(OverthereFile executable) {
        executable.setExecutable(true);
        CmdLine cmdLine = CmdLine.build((String[])new String[]{"nocd", this.runCommand, executable.getPath()});
        DefaultExecutionOutputHandler stdoutHandler = DefaultExecutionOutputHandler.handleStdout((ExecutionContext)this.getCtx());
        DefaultExecutionOutputHandler stderrHandler = DefaultExecutionOutputHandler.handleStderr((ExecutionContext)this.getCtx());
        try {
            this.getCtx().logOutput("Executing " + executable.getPath() + " on host " + this.getContainer().getHost());
            this.getCtx().logOutput("Command line: " + cmdLine);
            int rc = this.getRemoteConnection().execute((OverthereExecutionOutputHandler)stdoutHandler, (OverthereExecutionOutputHandler)stderrHandler, cmdLine);
            if (rc != 0) {
                this.getCtx().logError("Execution failed with return code " + rc);
                StepExitCode stepExitCode = StepExitCode.FAIL;
                return stepExitCode;
            }
            StepExitCode stepExitCode = StepExitCode.SUCCESS;
            return stepExitCode;
        }
        finally {
            try {
                Closeables.close((Closeable)stdoutHandler, (boolean)true);
            }
            catch (IOException e) {}
            try {
                Closeables.close((Closeable)stderrHandler, (boolean)true);
            }
            catch (IOException e) {}
        }
    }
}

