/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.osb.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.LenientTemplateResolvingHostFileInputTransformer;
import com.xebialabs.deployit.plugin.osb.ci.OsbJar;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;

@SuppressWarnings("serial")
public class ImportOsbConfigurationStep extends WlsStepBase {

	static final String WLST_SCRIPT_DIRECTORY = "com/xebialabs/deployit/plugin/osb/step/";
	static final String DEPLOY_CONFIGURATION_ON_OSB_SCRIPT_NAME = WLST_SCRIPT_DIRECTORY + "import-osb-configuration-3.0.py";
	private static final String OSB_JAR_EXTENSION = ".jar";

	private String applicationLocation;
	private String applicationName;
	private String extension;
	private String project;
	private String customFile;
	protected Map<String, String> properties;
	protected PlaceholderFormat placeholderFormat;

	public ImportOsbConfigurationStep(WlsDomain domain, OsbJar application, String customFile, Map<String, String> properties,
	        PlaceholderFormat placeholderFormat) {
		this(domain, application);
		this.customFile = customFile;
		this.properties = properties;
		this.placeholderFormat = placeholderFormat;
		if (properties == null || properties.isEmpty())
			setDescription("Import OSB Project " + this.project + " on " + domain + " using customization file ");
		else
			setDescription("Import OSB Project " + this.project + " on " + domain + " using customization file and properties replacement");
	}

	public ImportOsbConfigurationStep(WlsDomain domain, OsbJar application) {
		super(domain);
		this.applicationLocation = application.getLocation();
		this.applicationName = application.getName();
		this.extension = OSB_JAR_EXTENSION;
		this.project = application.getProjectName();
		setDescription("Import OSB Project " + this.project + " on " + domain);
	}

	String getProject() {
		return project;
	}

	public String getCustomFile() {
		return customFile;
	}

	private HostFile uploadApplication(HostSession rhs) {
		HostFile uploadedApplicationFile;
		HostSession lhs = Host.getLocalHost().getHostSession();
		try {
			HostFile applicationFileToUpload = lhs.getFile(applicationLocation);
			uploadedApplicationFile = rhs.getTempFile(applicationName, extension);
			HostFileUtils.copy(applicationFileToUpload, uploadedApplicationFile);
			return uploadedApplicationFile;
		} finally {
			lhs.close();
		}
	}

	@SuppressWarnings("deprecation")
	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = domain.connectToAdminHost();
		try {
			HostFile uploadedApplication = uploadApplication(rhs);
			String uploadedApplicationPath = uploadedApplication.getPath().replace('\\', '/');

			CmdLine cmdLine = new CmdLine();
			cmdLine.addArgument(domain.getUsername());
			cmdLine.addArgument(domain.getPassword());
			cmdLine.addArgument(domain.getConnectUrl());
			cmdLine.addArgument(getProject());
			cmdLine.addArgument(uploadedApplicationPath);

			if (getCustomFile() != null) {
				HostFile tempFile = rhs.getTempFile(applicationName, ".xml");
				HostSession localSession = Host.getLocalHost().getHostSession();
				try {
					// can't use the archive-supporting transformer because it rejects the source file
					HostFileUtils.copyFile(localSession.getFile(customFile), tempFile, new LenientTemplateResolvingHostFileInputTransformer(properties,
					        placeholderFormat));
				} finally {
					localSession.close();
				}
				cmdLine.addArgument(tempFile.getPath());
			}
			int res = executeWlstJythonScriptResource(ctx, rhs, DEPLOY_CONFIGURATION_ON_OSB_SCRIPT_NAME, cmdLine);
			return res == 0;

		} finally {
			rhs.close();
		}
	}

}
