/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.osb.ci;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemRoot;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.CmdLineArgument;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.osb.ci.OsbVersion;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.util.ExtendedResourceUtils;
import com.xebialabs.deployit.util.TemplateResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@ConfigurationItem(description="Oracle Service Bus Domain", category="middleware", root=ConfigurationItemRoot.INFRASTRUCTURE)
public class OsbDomain
extends WlsDomain {
    protected static final String OSB_WLST_PACKAGE = "com/xebialabs/deployit/plugin/osb";
    @ConfigurationItemProperty(required=true, description="The location of the Oracle Service Bus.", size=ConfigurationItemProperty.Size.LARGE)
    private String osbHome;
    @ConfigurationItemProperty(description="The version of OSB. Defaualts to OSB 3.0")
    private OsbVersion version = OsbVersion.OSB_3_0;
    private static final Logger logger = LoggerFactory.getLogger(OsbDomain.class);

    public String getOsbHome() {
        return this.osbHome;
    }

    public void setOsbHome(String osbHome) {
        this.osbHome = osbHome;
    }

    public OsbVersion getVersion() {
        return this.version;
    }

    public void setVersion(OsbVersion version) {
        this.version = version;
    }

    public int executeWlstJythonScript(CommandExecutionCallbackHandler handler, HostSession s, String scriptPath, CmdLine cmdLine) {
        ArrayList<String> cmd = new ArrayList<String>();
        switch (this.getActiveHost().getOperatingSystemFamily()) {
            case UNIX: {
                logger.info("Uploading wlst.sh from Deployit distribution to add required libraries to the classpath.");
                HostFile uploadedWlstSh = s.copyToTemporaryFile(this.getWlstScript());
                cmd.add("/bin/sh");
                cmd.add(uploadedWlstSh.getPath());
                cmd.add(this.getWlHome());
                cmd.add(this.getOsbHome());
                break;
            }
            case WINDOWS: {
                logger.info("Uploading wlst.cmd from Deployit distribution to add required libraries to the classpath.");
                HostFile uploadedWlstCmd = s.copyToTemporaryFile(this.getWlstScript());
                cmd.add(uploadedWlstCmd.getPath());
            }
        }
        cmd.add("-i");
        cmd.add(scriptPath);
        for (CmdLineArgument eachArgument : cmdLine.getArguments()) {
            cmd.add(eachArgument.getArg());
        }
        String[] cmdArray = cmd.toArray(new String[cmd.size()]);
        return s.execute(handler, cmdArray);
    }

    public Resource getWlstScript() {
        String extension;
        OperatingSystemFamily operatingSystemFamily = this.getActiveHost().getOperatingSystemFamily();
        switch (operatingSystemFamily) {
            case UNIX: {
                extension = ".sh";
                break;
            }
            case WINDOWS: {
                extension = ".cmd";
                break;
            }
            default: {
                throw new IllegalArgumentException(operatingSystemFamily + " is not supported for getting the wlst script");
            }
        }
        String scriptName = "wlst" + extension;
        String template = ExtendedResourceUtils.toString((Resource)new ClassPathResource("com/xebialabs/deployit/plugin/osb/" + scriptName));
        HashMap context = Maps.newHashMap();
        context.put("configFwkJarFile", ResourceBundle.getBundle("com/xebialabs/deployit/plugin/osb.configfwk").getString(this.version.toString()));
        context.put("wlHome", this.getWlHome());
        context.put("osbHome", this.getOsbHome());
        TemplateResolver r = new TemplateResolver((Map)context);
        String resolvedTemplate = r.resolveLenient(template);
        HostSession localHostSession = Host.getLocalHost().getHostSession();
        HostFile localScriptFile = localHostSession.getTempFile("wlst", extension);
        HostFileUtils.putStringToHostFile((String)resolvedTemplate, (HostFile)localScriptFile);
        return new FileSystemResource(localScriptFile.getPath());
    }
}

