/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.osb.container;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.osb.freemarker.TemplateEvaluator;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, description="OSB domain on the WebLogic server")
public class Domain
extends com.xebialabs.deployit.plugin.wls.container.Domain
implements WlsContainer {
    @Property(required=true, defaultValue="osb/runtime", hidden=true)
    private String pythonRuntimePath;
    @Property(required=true, defaultValue="osb", hidden=true, description="Path containing the wlst templates: wlst.sh.ftl (Unix) and wlst.cmd.ftl (Windows)")
    private String wlstTemplatePath;

    public CmdLine getScriptCommandLine(OverthereFile overthereFile) {
        OverthereFile overthereFile2;
        String string;
        CmdLine cmdLine = new CmdLine();
        OverthereFile overthereFile3 = LocalConnection.getLocalConnection().getTempFile("osb_plugin", ".tmp");
        if (this.getHost().getOs() == OperatingSystemFamily.UNIX) {
            string = this.wlstTemplatePath + "/wlst.sh.ftl";
            overthereFile2 = overthereFile.getParentFile().getFile("wlst.sh");
            cmdLine.addArgument("sh");
        } else {
            string = this.wlstTemplatePath + "/wlst.cmd.ftl";
            overthereFile2 = overthereFile.getParentFile().getFile("wlst.cmd");
        }
        cmdLine.addArgument(overthereFile2.getPath());
        TemplateEvaluator.evaluateTemplate(overthereFile3, string, (Map<String, Object>)ImmutableMap.of((Object)"container", (Object)((Object)this), (Object)"script", (Object)overthereFile.getPath()));
        overthereFile3.copyTo(overthereFile2);
        return cmdLine;
    }

    public String getRuntimePath() {
        return (String)this.getProperty("pythonRuntimePath");
    }

    public com.xebialabs.deployit.plugin.wls.container.Domain getDomain() {
        return this;
    }

    public String getObjectName() {
        return "";
    }

    public Set<Host> getHosts() {
        return Sets.newHashSet((Object[])new Host[]{this.getHost()});
    }

    public Set<Server> getServers() {
        return Collections.emptySet();
    }
}

