#
import re

from com.xebialabs.deployit.plugin.api.reflect import Type
from policy.modules.deployment.registry import PolicyRegistry
from policy.modules.util import Struct


class PackageCleaner():
    def __init__(self, context):
        self.context = Struct(context)
        self.repository_service = self.context.repositoryService
        self.logger = self.context.logger

        exec "from policy.modules.deployment.policies import *"
        exec "from policy.modules.deployment.ext import *"

    def _read_package_ids(self, app_id):
        package_ids = [package.id for package in self.repository_service.query(Type.valueOf("udm.Version"), app_id, None, None, None, None, 0, -1)]
        package_ids.sort()
        return package_ids

    def _pick_by_regex(self, pattern, package_ids):
        regex_pattern = re.compile(pattern)
        return [package_id for package_id in package_ids if regex_pattern.match(package_id)]

    def _omit_deployed(self, app_id, packages_ids):
        app_name = app_id[app_id.rfind("/") + 1:]
        deployed_apps = self.repository_service.query(Type.valueOf("udm.DeployedApplication"), None, "Environments", app_name, None, None, 0, -1)
        deployed_package_ids = [self.repository_service.read(deployed_app.id).version.id for deployed_app in deployed_apps]
        return [package_id for package_id in packages_ids if package_id not in deployed_package_ids]

    def _find_packages_to_remove(self, app_id, job):
        package_ids = self._read_package_ids(app_id)
        package_ids = self._pick_by_regex(job.pattern, package_ids)
        if package_ids:
            policy = PolicyRegistry.new_policy(job.policyType, self.context)
            package_ids = policy.filter(app_id, job, package_ids)
            if package_ids:
                package_ids = self._omit_deployed(app_id, package_ids)
        return package_ids

    def _remove_packages(self, package_ids):
        self.logger.info("Removing packages...")
        try:
            self.repository_service.deleteList(package_ids)
        except:
            self.logger.error("Error deleting packages")
            raise

    def run(self, job):
        self.logger.info("=== Running package purge job [%s] (retention: %s, dryRun: %s) ===" % (job.name, str(job.packageRetention), job.dryRun))
        for app in self.repository_service.query(Type.valueOf("udm.Application"), None, "Applications", None, None, None, 0, -1):
            package_ids = self._find_packages_to_remove(app.id, job)
            self.logger.info("== %s [packages to remove: %s]" % (app.id, len(package_ids)))
            if package_ids:
                self.logger.info("Packages: %s" % ", ".join([package_id[package_id.rfind("/") + 1:] for package_id in package_ids]))
                if not job.dryRun:
                    self._remove_packages(package_ids)
        self.logger.info("=== Finished package purge job [%s] ===" % job.name)