/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.remoting.vars.VarsConverter;
import com.xebialabs.overthere.OverthereConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class PowerShellVarsConverter
extends VarsConverter {
    public static String javaToPowerShell(OverthereConnection overthereConnection, Map<String, Object> map) {
        return PowerShellVarsConverter.javaToPowerShell(overthereConnection, map, true);
    }

    public static String javaToPowerShell(OverthereConnection overthereConnection, Map<String, Object> map, boolean bl) {
        List<String> list = PowerShellVarsConverter.javaToPowerShellList(overthereConnection, map, bl);
        return Joiner.on((String)"\n").join(list) + "\n";
    }

    static List<String> javaToPowerShellList(OverthereConnection overthereConnection, Map<String, Object> map, boolean bl) {
        PowerShellVarsConverter powerShellVarsConverter = new PowerShellVarsConverter(overthereConnection, map);
        powerShellVarsConverter.setUploadArtifactData(bl);
        return powerShellVarsConverter.convert();
    }

    private PowerShellVarsConverter(OverthereConnection overthereConnection, Map<String, Object> map) {
        super(overthereConnection, map);
    }

    protected void setNullVariable(String string) {
        this.add("$" + string + " = $null");
    }

    protected void setBooleanVariable(String string, boolean bl) {
        this.add("$" + string + " = " + PowerShellVarsConverter.toPowerShellBoolean(bl));
    }

    protected void setIntegerVariable(String string, int n) {
        this.add("$" + string + " = " + n);
    }

    protected void setLongVariable(String string, long l) {
        this.add("$" + string + " = " + l);
    }

    protected void setStringVariable(String string, String string2) {
        this.add("$" + string + " = " + PowerShellVarsConverter.toPowerShellString(string2));
    }

    private void setEmptyCollectionVar(String string) {
        this.add("$" + string + " = @()");
    }

    protected void setCollectionOfStringsVariable(String string, Collection<?> collection) {
        if (collection.isEmpty()) {
            this.setEmptyCollectionVar(string);
        } else {
            this.add("$" + string + " = " + PowerShellVarsConverter.toPowerShellCollectionOfStrings(collection));
        }
    }

    protected void createObject(String string) {
        this.add("$" + string + " = New-Object Object");
    }

    private void setNoteProperty(String string, String string2, String string3) {
        this.add("$" + string + " | Add-Member NoteProperty " + PowerShellVarsConverter.toPowerShellString(string2) + " " + string3);
    }

    protected void setNullProperty(String string, String string2) {
        this.setNoteProperty(string, string2, "$null");
    }

    protected void setEmptyCollectionProperty(String string, String string2) {
        this.setNoteProperty(string, string2, "@()");
    }

    protected void setEmptyMapProperty(String string, String string2) {
        this.setNoteProperty(string, string2, "@{}");
    }

    protected void setBooleanProperty(String string, String string2, boolean bl) {
        this.setNoteProperty(string, string2, PowerShellVarsConverter.toPowerShellBoolean(bl));
    }

    protected void setIntegerProperty(String string, String string2, int n) {
        this.setNoteProperty(string, string2, Integer.toString(n));
    }

    protected void setStringProperty(String string, String string2, String string3) {
        this.setNoteProperty(string, string2, PowerShellVarsConverter.toPowerShellString(string3));
    }

    protected void setPasswordProperty(String string, String string2, String string3) {
        this.setNoteProperty(string, string2, "([System.Text.Encoding]::UTF8.GetString([System.Convert]::FromBase64String(" + PowerShellVarsConverter.toPowerShellString(Base64.encodeBase64String((byte[])string3.getBytes())) + ")))");
    }

    protected void setCollectionOfStringsProperty(String string, String string2, Collection<?> collection) {
        this.setNoteProperty(string, string2, PowerShellVarsConverter.toPowerShellCollectionOfStrings(collection));
    }

    protected void setCiReferenceProperty(String string, String string2, ConfigurationItem configurationItem) {
        this.setNoteProperty(string, string2, "$" + this.getConfigurationItemVariableName(configurationItem));
    }

    protected void setCollectionOfCiReferencesProperty(String string, String string2, Collection<ConfigurationItem> collection) {
        if (collection.isEmpty()) {
            this.setEmptyCollectionVar(string + "." + string2);
        } else {
            ArrayList arrayList = Lists.newArrayList();
            for (ConfigurationItem configurationItem : collection) {
                arrayList.add("$" + this.getConfigurationItemVariableName(configurationItem));
            }
            this.setNoteProperty(string, string2, "@(" + Joiner.on((String)", ").join((Iterable)arrayList) + ")");
        }
    }

    protected void setMapOfStringToStringReferencesProperty(String string, String string2, Map<String, String> map) {
        if (map.isEmpty()) {
            this.setEmptyMapProperty(string, string2);
        } else {
            ArrayList arrayList = Lists.newArrayList();
            for (String string3 : map.keySet()) {
                String string4 = map.get(string3);
                if (string4 == null) {
                    arrayList.add(PowerShellVarsConverter.toPowerShellString(string3) + " = $null");
                    continue;
                }
                arrayList.add(PowerShellVarsConverter.toPowerShellString(string3) + " = " + PowerShellVarsConverter.toPowerShellString(string4));
            }
            this.setNoteProperty(string, string2, "@{" + Joiner.on((String)"; ").join((Iterable)arrayList) + "}");
        }
    }

    protected void createObjectAndSetObjectProperty(String string, String string2) {
        String string3 = this.generateUniqueVariableName();
        this.createObject(string3);
        this.setNoteProperty(string, string2, "$" + string3);
    }

    public static String toPowerShellBoolean(Boolean bl) {
        return bl != false ? "$true" : "$false";
    }

    public static String toPowerShellString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append('\"');
                }
            }
            stringBuilder.append(c);
        }
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    public static String toPowerShellCollectionOfStrings(Collection<?> collection) {
        Collection collection2 = Collections2.transform(collection, (Function)new Function<Object, String>(){

            public String apply(Object object) {
                return PowerShellVarsConverter.toPowerShellString(object.toString());
            }
        });
        return "@(" + Joiner.on((String)", ").join((Iterable)collection2) + ")";
    }
}

