/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.powershell.PowerShellContainer;
import com.xebialabs.deployit.plugin.powershell.PowerShellDeploymentStep;
import java.util.HashMap;
import java.util.Map;

@Metadata(virtual=true)
public class BasePowerShellDeployed<D extends Deployable, C extends PowerShellContainer>
extends BaseDeployed<D, C> {
    @Property(required=false, hidden=true, defaultValue="false", description="If set to true, the deployed application CI is exposed to the PowerShell script.")
    private boolean exposeDeployedApplication;

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String scriptPath, String verb) {
        return this.addStep(ctx, order, scriptPath, verb, true);
    }

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String scriptPath, String verb, boolean uploadArtifactData) {
        if (scriptPath != null) {
            PowerShellDeploymentStep step = new PowerShellDeploymentStep(order, (PowerShellContainer)this.getContainer(), scriptPath, this.getVars(ctx.getDeployedApplication()), this.getDescription(verb));
            step.setUploadArtifactData(uploadArtifactData);
            ctx.addStep((DeploymentStep)step);
            return true;
        }
        return false;
    }

    protected Map<String, Object> getVars(DeployedApplication deployedApplication) {
        HashMap vars = Maps.newHashMap();
        vars.put("deployed", this);
        if (this.exposeDeployedApplication) {
            Preconditions.checkNotNull((Object)deployedApplication, (Object)"deployedApplication is null");
            vars.put("deployedApplication", deployedApplication);
        }
        return vars;
    }

    protected String getDescription(String verb) {
        return String.format("%s %s on %s", verb, this.getName(), ((PowerShellContainer)this.getContainer()).getName());
    }

    public boolean getExposeDeployedApplication() {
        return this.exposeDeployedApplication;
    }

    public void setExposeDeployedApplication(boolean exposeDeployedApplication) {
        this.exposeDeployedApplication = exposeDeployedApplication;
    }
}

