/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.powershell.BasePowerShellDeployed;

@Metadata(virtual=true)
public class BaseExtensiblePowerShellDeployed<D extends Deployable>
extends BasePowerShellDeployed<D, HostContainer> {
    @Property(hidden=true, required=false, description="PowerShell script invoked to deploy an artifact or a resource on Windows.")
    private String createScript;
    @Property(hidden=true, defaultValue="Create", description="Verb that is used to prefix a step description for the create operation.")
    private String createVerb;
    @Property(hidden=true, defaultValue="60", description="Order in which a create step will be executed.")
    private int createOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to upgrade an artifact or a resource on Windows.")
    private String modifyScript;
    @Property(hidden=true, defaultValue="Modify", description="Verb that is used to prefix a step description for the modify operation.")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="60", description="Order in which a modify step will be executed.")
    private int modifyOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to undeploy an artifact or a resource on Windows.")
    private String destroyScript;
    @Property(hidden=true, defaultValue="Destroy", description="Verb that is used to prefix a step description for the destroy operation.")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="40", description="Order in which a destroy step will be executed.")
    private int destroyOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to noop an artifact or a resource on Windows.")
    private String noopScript;
    @Property(hidden=true, defaultValue="Noop", description="Verb that is used to prefix a step description for the noop operation.")
    private String noopVerb;
    @Property(hidden=true, defaultValue="50", description="Order in which a noop step will be executed.")
    private int noopOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to start an artifact or resource on Windows.")
    private String startScript;
    @Property(hidden=true, defaultValue="Start", description="Verb that is used to prefix a step description for the start operation.")
    private String startVerb;
    @Property(hidden=true, defaultValue="90", description="Order in which a start step will be executed.")
    private int startOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to stop an artifact or resource on Windows.")
    private String stopScript;
    @Property(hidden=true, defaultValue="Stop", description="Verb that is used to prefix a step description for the stop operation.")
    private String stopVerb;
    @Property(hidden=true, defaultValue="10", description="Order in which a synchronize after modify stop will be executed.")
    private int stopOrder;
    @Property(hidden=true, defaultValue="false", description="If set to true, the stop and start operations will be executed for the noop operation.")
    private boolean stopStartOnNoop;

    @Create
    public void create(DeploymentPlanningContext ctx, Delta delta) {
        this.addStep(ctx, delta, Operation.CREATE, this.createOrder, this.createScript, this.createVerb, true);
        this.addStep(ctx, delta, Operation.CREATE, this.startOrder, this.startScript, this.startVerb, true);
    }

    @Modify
    public void modify(DeploymentPlanningContext ctx, Delta delta) {
        if (this.addStep(ctx, delta, Operation.MODIFY, this.modifyOrder, this.modifyScript, this.modifyVerb, true)) {
            this.addStep(ctx, delta, Operation.MODIFY, this.startOrder, this.startScript, this.startVerb, true);
            this.addStep(ctx, delta, Operation.MODIFY, this.stopOrder, this.stopScript, this.stopVerb, true);
        } else {
            BaseExtensiblePowerShellDeployed previous = (BaseExtensiblePowerShellDeployed)delta.getPrevious();
            previous.destroy(ctx, delta);
            BaseExtensiblePowerShellDeployed current = (BaseExtensiblePowerShellDeployed)delta.getDeployed();
            current.create(ctx, delta);
        }
    }

    @Destroy
    public void destroy(DeploymentPlanningContext ctx, Delta delta) {
        this.addStep(ctx, delta, Operation.DESTROY, this.destroyOrder, this.destroyScript, this.destroyVerb, false);
        this.addStep(ctx, delta, Operation.DESTROY, this.stopOrder, this.stopScript, this.stopVerb, true);
    }

    @Noop
    public void noop(DeploymentPlanningContext ctx, Delta delta) {
        this.addStep(ctx, delta, Operation.NOOP, this.noopOrder, this.noopScript, this.noopVerb, false);
        if (this.stopStartOnNoop) {
            this.addStep(ctx, delta, Operation.NOOP, this.stopOrder, this.stopScript, this.stopVerb, true);
            this.addStep(ctx, delta, Operation.NOOP, this.startOrder, this.startScript, this.startVerb, true);
        }
    }
}

