package com.xebialabs.deployit.plugin.powershell;

import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
@Metadata(virtual = true)
public class BasePowerShellDeployed<D extends Deployable, C extends HostContainer> extends BaseDeployed<D, C> {

    @Property(required = false, hidden = true, defaultValue = "false", description = "If set to true, the deployed application CI is exposed to the PowerShell script.")
    private boolean exposeDeployedApplication;

    protected boolean addStep(DeploymentPlanningContext ctx, Delta delta, Operation operation, int order, String scriptPath, String verb) {
        return addStep(ctx, delta, operation, order, scriptPath, verb, true);
    }

    protected boolean addStep(DeploymentPlanningContext ctx, Delta delta, Operation operation, int order, String scriptPath, String verb, boolean uploadArtifactData) {
        if (scriptPath != null) {
            PowerShellDeploymentStep step = new PowerShellDeploymentStep(order, getContainer(), scriptPath, getVars(ctx.getDeployedApplication()), getDescription(verb));
            step.setUploadArtifactData(uploadArtifactData);
            ctx.addStepWithCheckpoint(step, delta, operation);
            return true;
        } else {
            return false;
        }
    }

    protected Map<String, Object> getVars(DeployedApplication deployedApplication) {
        Map<String, Object> vars = newHashMap();
        vars.put("deployed", this);
        if (exposeDeployedApplication) {
            checkNotNull(deployedApplication, "deployedApplication is null");
            vars.put("deployedApplication", deployedApplication);
        }
        return vars;
    }

    protected String getDescription(String verb) {
        return String.format("%s %s on %s", verb, getName(), getContainer().getName());
    }

    public boolean getExposeDeployedApplication() {
        return exposeDeployedApplication;
    }

    public void setExposeDeployedApplication(boolean exposeDeployedApplication) {
        this.exposeDeployedApplication = exposeDeployedApplication;
    }

    public List<Step> controlTaskDispatch(String name, Map<String,String> args) {
        return ControlTaskDelegate.dispatch(name, args, this, getContainer());
    }

}
