package com.xebialabs.deployit.plugin.powershell;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;

import java.util.List;

/**
 * A container that can be managed by running PowerShell scripts.
 */
public interface PowerShellContainer extends Container, HostContainer {

    /**
     * Returns the host on which this container runs.
     */
    Host getHost();

    /**
     * Generates the command line that should be used to run a script.
     * 
     * @param script
     *            the script to run
     * @return the command line to use to run the script.
     */
    CmdLine getScriptCommandLine(OverthereFile script);

    /**
     * Returns the name of the directory on the classpath that contains the Python scripts that define the runtime for this container.
     */
    List<String> getLibraryScripts();

}
