package com.xebialabs.deployit.plugin.powershell;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.DeployedSpecific;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.overthere.OverthereFile;

import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Base class for all extensible PowerShell deployed artifact configuration items.")
@Placeholders
public class ExtensiblePowerShellDeployedArtifact extends BaseExtensiblePowerShellDeployed<DeployableArtifact> implements DerivedArtifact<DeployableArtifact> {

    private OverthereFile derivedFile;

    @Property(description = "A Map containing all the placeholders mapped to their values. Special values are <ignore> or <empty>", required = false)
    @DeployedSpecific
    private Map<String, String> placeholders = newHashMap();

    @Override
    public OverthereFile getFile() {
        return derivedFile;
    }

    @Override
    public void setFile(OverthereFile file) {
        this.derivedFile = file;
    }

    @Override
    public DeployableArtifact getSourceArtifact() {
        return getDeployable();
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return placeholders;
    }

    @Override
    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }
}
