/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.powershell.BasePowerShellDeployed;
import com.xebialabs.deployit.plugin.powershell.PowerShellContainer;
import com.xebialabs.deployit.plugin.powershell.PowerShellIniConverter;
import com.xebialabs.deployit.plugin.powershell.PowerShellStepUtils;
import com.xebialabs.deployit.plugin.powershell.PowerShellVarsConverter;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.deployit.plugin.remoting.vars.VarsConverter;
import com.xebialabs.deployit.plugin.steps.CalculatedStep;
import com.xebialabs.deployit.plugin.steps.ContextHelper;
import com.xebialabs.deployit.plugin.steps.TargetContainerJavaHelper;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PowerShellStep
extends CalculatedStep
implements PreviewStep,
StageableStep,
SatelliteAware {
    private static final String BASE_RUNTIME_PATH = "powershell/runtime";
    @StepParameter(name="targetHost", description="The target host to run the script on", calculated=true)
    private HostContainer container;
    Deployed<?, ?> deployed;
    @StepParameter(name="script", description="Path to the Powershell script to execute (relative to XL Deploy's classpath)")
    private String scriptPath;
    @StepParameter(name="powershellContext", description="The variables to pass to the Powershell step", required=false, calculated=true)
    Map<String, Object> powershellVars;
    @StepParameter(name="uploadArtifacts", description="If true, the artifacts from the powershell context will be uploaded to the target host and available to the script as $bindingName.file. Defaults to true.")
    private Boolean uploadArtifactData = true;
    private List<String> classpathResources = Lists.newArrayList();
    private static Logger logger = LoggerFactory.getLogger(PowerShellStep.class);

    @RulePostConstruct
    public void doPostConstruct(StepPostConstructContext ctx) {
        super.doPostConstruct(ctx);
        if (this.container == null) {
            this.container = (HostContainer)TargetContainerJavaHelper.defaultTargetContainer((StepPostConstructContext)ctx, HostContainer.class);
        }
        this.powershellVars = ContextHelper.defaultContext((StepPostConstructContext)ctx, this.powershellVars);
    }

    public PowerShellStep(HostContainer container, Deployed<?, ?> deployed, String scriptPath, Map<String, Object> powerShellVars, Integer order, String description) {
        super((Integer)Preconditions.checkNotNull((Object)order, (Object)"order is null"), (String)Preconditions.checkNotNull((Object)description, (Object)"description is null"));
        this.container = (HostContainer)Preconditions.checkNotNull((Object)container, (Object)"container is null");
        Preconditions.checkArgument((this.container.getHost().getOs() == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (Object)"Powershell scripts can only be run on Windows hosts");
        this.deployed = deployed;
        this.scriptPath = (String)Preconditions.checkNotNull((Object)scriptPath, (Object)"scriptPath is null");
        this.powershellVars = (Map)Preconditions.checkNotNull(powerShellVars, (Object)"powershellVars is null");
    }

    public PowerShellStep(HostContainer container, Deployed<?, ?> deployed, String scriptPath, Map<String, Object> powerShellVars, String description) {
        this(container, deployed, scriptPath, powerShellVars, null, description);
    }

    public PowerShellStep() {
        this.powershellVars = Collections.emptyMap();
    }

    public void requestStaging(StagingContext ctx) {
        if (!this.uploadArtifactData.booleanValue()) {
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(this.powershellVars);
        for (Map.Entry<String, Object> entry : this.powershellVars.entrySet()) {
            if (!(entry.getValue() instanceof Artifact)) continue;
            StagedFile stagedFile = ctx.stageArtifact((Artifact)entry.getValue(), (StagingTarget)this.container.getHost());
            result.put(entry.getKey() + "_stagedFile", stagedFile);
        }
        this.powershellVars = result;
    }

    public Preview getPreview() {
        return PowerShellStepUtils.previewPowerShellScript(this.getPowerShellScriptCallback(null, true, false));
    }

    protected StepExitCode doExecute(ExecutionContext ctx) throws Exception {
        return PowerShellStepUtils.executePowerShellScript(this.container, ctx, this.getPowerShellScriptCallback(ctx, false, this.uploadArtifactData), this.getPowerShellScriptCallback(ctx, true, false));
    }

    PowerShellStepUtils.PowerShellScriptCallback getPowerShellScriptCallback(final ExecutionContext ctx, final boolean maskPasswords, final boolean uploadArtifacts) {
        return new PowerShellStepUtils.PowerShellScriptCallback(){
            private VarsConverter converter;
            private boolean scriptGenerated;
            private OverthereFile iniFile;

            @Override
            public String getScriptPath() {
                return PowerShellStep.this.scriptPath;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String generateScript(OverthereConnection conn) {
                boolean exposePasswordPropertiesOnHosts = PowerShellStep.this.deployed instanceof BasePowerShellDeployed && ((BasePowerShellDeployed)PowerShellStep.this.deployed).exposePasswordPropertiesOnHosts();
                this.iniFile = conn.getTempFile(PowerShellStep.this.deployed.getName(), ".ini");
                this.converter = this.usesSidecar() ? new PowerShellIniConverter(conn, PowerShellStep.this.powershellVars, maskPasswords, exposePasswordPropertiesOnHosts, this.iniFile.getPath()) : new PowerShellVarsConverter(conn, PowerShellStep.this.powershellVars, maskPasswords, exposePasswordPropertiesOnHosts);
                this.converter.setUploadArtifactData(uploadArtifacts);
                this.converter.setExecutionContext(ctx);
                try {
                    String string = PowerShellStep.this.doGenerateScript(this.converter);
                    return string;
                }
                finally {
                    this.scriptGenerated = true;
                }
            }

            @Override
            public void uploadAdditionalResources(HostContainer container, ExecutionContext ctx2, OverthereConnection conn) {
                PowerShellStep.this.doUploadClasspathResources(conn);
                if (this.usesSidecar()) {
                    if (!this.scriptGenerated) {
                        throw new IllegalStateException("Should call 'generateScript' before uploading additional resources if sidecar is being used");
                    }
                    PowerShellStep.this.uploadIniFile((PowerShellIniConverter)this.converter, this.iniFile);
                }
            }

            private boolean usesSidecar() {
                return PowerShellStep.this.deployed instanceof BasePowerShellDeployed && ((BasePowerShellDeployed)PowerShellStep.this.deployed).useSidecarIniFile();
            }
        };
    }

    private void uploadIniFile(PowerShellIniConverter converter, OverthereFile iniFile) {
        String convertedIniContents = Joiner.on((String)"\r\n").join(converter.getConvertedIniContents());
        OverthereUtils.write((String)convertedIniContents, (String)"UTF-8", (OverthereFile)iniFile);
    }

    String doGenerateScript(VarsConverter converter) {
        logger.debug("Starting generation of PowerShell script for step [{}]", (Object)this.getDescription());
        StringBuilder scriptBuilder = new StringBuilder();
        logger.debug("Appending runtime scripts");
        this.appendBaseRuntimeScript(scriptBuilder);
        logger.debug("Appending container runtime scripts");
        this.appendContainerRuntimeScripts(scriptBuilder);
        logger.debug("Appending container library scripts");
        this.appendContainerLibraryScripts(scriptBuilder);
        logger.debug("Appending deployed library scripts");
        this.appendDeployedLibraryScripts(scriptBuilder);
        logger.debug("Appending PowerShell vars");
        this.appendPowerShellVars(converter, scriptBuilder);
        logger.debug("Appending script");
        this.appendScript(scriptBuilder);
        logger.debug("Replacing all LF's that are NOT preceded by a CR with CRLF.");
        String script = scriptBuilder.toString().replaceAll("(?<!\r)\n", "\r\n");
        logger.debug("Finished generation of PowerShell script.");
        return script;
    }

    private void appendBaseRuntimeScript(StringBuilder b) {
        ScriptUtils.appendScriptDir((String)BASE_RUNTIME_PATH, (StringBuilder)b);
    }

    private void appendContainerRuntimeScripts(StringBuilder b) {
        if (this.container.hasProperty("runtimePath")) {
            String runtimePath = (String)this.container.getProperty("runtimePath");
            ScriptUtils.appendScriptDir((String)runtimePath, (StringBuilder)b);
        }
    }

    private void appendContainerLibraryScripts(StringBuilder b) {
        if (this.container instanceof PowerShellContainer) {
            ScriptUtils.appendScripts(((PowerShellContainer)this.container).getLibraryScripts(), (StringBuilder)b);
        }
    }

    private void appendDeployedLibraryScripts(StringBuilder b) {
        if (this.deployed instanceof BasePowerShellDeployed) {
            ScriptUtils.appendScripts(((BasePowerShellDeployed)this.deployed).getLibraryScripts(), (StringBuilder)b);
        }
    }

    private void appendPowerShellVars(VarsConverter converter, StringBuilder b) {
        b.append("# PowerShellVars\n");
        b.append(Joiner.on((String)"\n").join((Iterable)converter.convert()));
        b.append("\n");
    }

    private void appendScript(StringBuilder b) {
        b.append(ScriptUtils.loadScript((String)this.scriptPath));
    }

    private void doUploadClasspathResources(OverthereConnection conn) {
        for (String r : this.classpathResources) {
            int indexOfLastSlash = r.lastIndexOf(47);
            String filename = indexOfLastSlash < 0 ? r : r.substring(indexOfLastSlash + 1);
            OverthereFile target = conn.getTempFile(filename);
            logger.info("Uploading classpath resource [{}] to temporary file [{}].", (Object)r, (Object)target);
            try {
                OutputStream out = target.getOutputStream();
                Throwable throwable = null;
                try {
                    URL resourceURL = Resources.getResource((String)r);
                    Resources.copy((URL)resourceURL, (OutputStream)out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (IOException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    public void setUploadArtifactData(boolean uploadArtifactData) {
        this.uploadArtifactData = uploadArtifactData;
    }

    public void setClasspathResources(List<String> classpathResources) {
        this.classpathResources = classpathResources;
    }

    public Satellite getSatellite() {
        return this.container.getHost().getSatellite();
    }
}

