/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.remoting.vars.VarsConverter;
import com.xebialabs.overthere.OverthereConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public abstract class BasePowershellVarsConverter
extends VarsConverter {
    public BasePowershellVarsConverter(OverthereConnection connection, Map<String, Object> pythonVars, boolean maskPasswords, boolean exposePasswordPropertiesOnHosts) {
        super(connection, pythonVars, maskPasswords, exposePasswordPropertiesOnHosts);
    }

    protected void endCreateObject(String variableName) {
    }

    protected void setNoteProperty(String objectName, String propertyName, String literalPropertyValue) {
        this.add("$" + objectName + " | Add-Member NoteProperty " + BasePowershellVarsConverter.toPowerShellString(propertyName) + " " + literalPropertyValue);
    }

    protected void setNullProperty(String objectName, String propertyName) {
        this.setNoteProperty(objectName, propertyName, "$null");
    }

    protected void setEmptyCollectionProperty(String objectName, String propertyName) {
        this.setNoteProperty(objectName, propertyName, "@()");
    }

    protected void setEmptyMapProperty(String objectName, String propertyName) {
        this.setNoteProperty(objectName, propertyName, "@{}");
    }

    protected void setCiReferenceProperty(String objectName, String propertyName, ConfigurationItem propertyValue) {
        this.setNoteProperty(objectName, propertyName, "$" + this.getConfigurationItemVariableName(propertyValue));
    }

    protected void setCollectionOfCiReferencesProperty(String objectName, String propertyName, Collection<ConfigurationItem> propertyValue) {
        ArrayList varRefs = Lists.newArrayList();
        for (ConfigurationItem setItem : propertyValue) {
            varRefs.add("$" + this.getConfigurationItemVariableName(setItem));
        }
        this.setNoteProperty(objectName, propertyName, "@(" + Joiner.on((String)", ").join((Iterable)varRefs) + ")");
    }

    protected void createObjectAndSetObjectProperty(String objectName, String propertyName) {
        String embeddedObjectVariableName = this.generateUniqueVariableName();
        this.startCreateObject(embeddedObjectVariableName);
        this.endCreateObject(embeddedObjectVariableName);
        this.setNoteProperty(objectName, propertyName, "$" + embeddedObjectVariableName);
    }

    public static String toPowerShellString(String str) {
        StringBuilder converted = new StringBuilder();
        converted.append("'");
        block3: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\'': {
                    converted.append("''");
                    continue block3;
                }
                default: {
                    converted.append(c);
                }
            }
        }
        converted.append("'");
        return converted.toString();
    }
}

