package com.xebialabs.deployit.plugin.python;

import static com.google.common.collect.Maps.newHashMap;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;

@SuppressWarnings("serial")
public abstract class PythonManagedDeployed<D extends Deployable, C extends PythonManagedContainer> extends BaseDeployed<D, C> {

	protected boolean addStep(DeploymentPlanningContext ctx, int order, String scriptPath, String verb) {
		if (scriptPath != null) {
			ctx.addStep(new PythonDeploymentStep(order, getContainer().getManagingContainer(), scriptPath, getPythonVars(), getDescription(verb)));
			return true;
		} else {
			return false;
		}
	}

	protected boolean addStep(InspectionPlanningContext ctx, String scriptPath, String verb) {
		if (scriptPath != null) {
			ctx.addStep(new PythonInspectionStep(this, getContainer().getManagingContainer(), scriptPath, getPythonVars(), getDescription(verb)));
			return true;
		} else {
			return false;
		}
	}

	protected Map<String, Object> getPythonVars() {
		Map<String, Object> pythonVars = newHashMap();
		pythonVars.put("deployed", this);
		return pythonVars;
	}

	protected String getDescription(String verb) {
		return String.format("%s %s on %s", verb, getName(), getContainer().getName());
	}

}
