/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.ExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.python.PythonVarsConverter;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class PythonStep<C extends ExecutionContext>
implements Step<C> {
    private static final String STANDARD_RUNTIME_PATH = "python/runtime";
    private static final String DAEMON_SCRIPT = "python/daemon/daemon.py";
    private static final String MDC_KEY_SCRIPT_PATH = "scriptPath";
    private static final String DAEMON_STARTED = "DEPLOYIT-DAEMON-STARTED";
    private static final String DAEMON_EXIT_CODE_MARKER = "DEPLOYIT-DAEMON-EXIT-VALUE: ";
    private static final String DAEMON_END_OF_COMMAND_MARKER = "DEPLOYIT-DAEMON-END-OF-COMMAND";
    private final PythonManagingContainer container;
    private final String scriptPath;
    private final Map<String, Object> pythonVars;
    private final String description;
    private static final Logger logger = LoggerFactory.getLogger((String)PythonStep.class.getName());

    public PythonStep(PythonManagingContainer container, String scriptPath, Map<String, Object> pythonVars, String description) {
        this.container = (PythonManagingContainer)Preconditions.checkNotNull((Object)container, (Object)"container is null");
        this.scriptPath = (String)Preconditions.checkNotNull((Object)scriptPath, (Object)"scriptPath is null");
        this.pythonVars = (Map)Preconditions.checkNotNull(pythonVars, (Object)"pythonVars is null");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Step.Result doExecute(ExecutionContext ctx) throws Exception {
        MDC.put((String)MDC_KEY_SCRIPT_PATH, (String)this.scriptPath);
        try {
            Step.Result result;
            OverthereConnection conn = this.container.getHost().getConnection();
            try {
                String finalScript = this.aggregateScript(conn);
                this.dumpScript(OverthereUtils.getName((String)this.scriptPath), finalScript);
                OverthereFile uploadedScriptFile = this.uploadScript(conn, this.scriptPath, finalScript);
                int res = this.executePythonScript(ctx, conn, uploadedScriptFile);
                result = res == 0 ? Step.Result.Success : Step.Result.Fail;
            }
            catch (Throwable throwable) {
                conn.close();
                throw throwable;
            }
            conn.close();
            return result;
        }
        finally {
            MDC.remove((String)MDC_KEY_SCRIPT_PATH);
        }
    }

    protected String aggregateScript(OverthereConnection connection) {
        String pythonVarsPython = PythonVarsConverter.javaToPython(connection, this.pythonVars);
        StringBuilder b = new StringBuilder();
        if (!this.container.runWithDaemon()) {
            b.append(this.loadScriptDir(STANDARD_RUNTIME_PATH));
            b.append(this.loadScriptDir(this.container.getRuntimePath()));
        }
        b.append("# PythonVars\n");
        b.append(pythonVarsPython);
        if (!this.container.runWithDaemon()) {
            b.append("#\nconnectFromStandAloneScript()\n");
        }
        b.append(this.loadScript(this.scriptPath));
        if (!this.container.runWithDaemon()) {
            b.append("#\ndisconnectFromStandAloneScript()\n");
        }
        String finalScript = b.toString();
        return finalScript;
    }

    private int executePythonScript(ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        if (this.container.runWithDaemon() && conn.canStartProcess()) {
            return this.executePythonScriptWithDaemon(ctx, script);
        }
        return conn.execute((OverthereProcessOutputHandler)new ExecutionContextOverthereProcessOutputHandler(ctx), this.container.getScriptCommandLine(script));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executePythonScriptWithDaemon(final ExecutionContext ctx, OverthereFile script) {
        DaemonProcessWrapper daemonProcessWrapper = this.getDaemonProcess(ctx);
        OverthereProcess daemonProcess = daemonProcessWrapper.getProcess();
        logger.info("Executing Python script {} on {}", (Object)script, (Object)daemonProcessWrapper.getConnection());
        String daemonLine = "runScriptFromDaemon(" + PythonVarsConverter.toPythonString(script.getPath()) + ")\n";
        OutputStream stdin = daemonProcess.getStdin();
        stdin.write(daemonLine.getBytes());
        stdin.flush();
        BufferedReader stdout = new BufferedReader(new InputStreamReader(daemonProcess.getStdout()));
        final BufferedReader stderr = new BufferedReader(new InputStreamReader(daemonProcess.getStderr()));
        Thread stderrThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String stderrLine;
                    while (!Thread.interrupted() && (stderrLine = stderr.readLine()) != null) {
                        ctx.logError(stderrLine);
                    }
                }
                catch (InterruptedIOException ie) {
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
        }, "stderr printer for python daemon running on " + this);
        stderrThread.start();
        try {
            int exitCode = 0;
            while (true) {
                String stdoutLine;
                if ((stdoutLine = stdout.readLine()) == null) {
                    throw new RuntimeIOException("Cannot execute script " + script.getPath() + " on " + this.container.getHost() + ": lost connection to the python daemon");
                }
                if (stdoutLine.startsWith(DAEMON_EXIT_CODE_MARKER)) {
                    try {
                        exitCode = Integer.parseInt(stdoutLine.substring(DAEMON_EXIT_CODE_MARKER.length()));
                    }
                    catch (NumberFormatException ignored) {}
                    continue;
                }
                if (stdoutLine.equals(DAEMON_END_OF_COMMAND_MARKER)) break;
                ctx.logOutput(stdoutLine);
            }
            int n = exitCode;
            stderrThread.interrupt();
            return n;
        }
        catch (Throwable throwable) {
            try {
                stderrThread.interrupt();
                throw throwable;
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot execute script " + script.getPath() + " on " + this.container.getHost(), (Throwable)exc);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DaemonProcessWrapper getDaemonProcess(ExecutionContext context) {
        String key = "DAEMON_" + this.container.getId();
        DaemonProcessWrapper wrappedProcess = (DaemonProcessWrapper)context.getAttribute(key);
        if (wrappedProcess == null) {
            OverthereConnection daemonConnection = this.container.getHost().getConnection();
            String daemonScript = this.generateDaemonScript();
            this.dumpScript("daemon.py", daemonScript);
            OverthereFile uploadedDaemonScript = this.uploadScript(daemonConnection, "daemon.py", daemonScript);
            OverthereProcess daemonProcess = daemonConnection.startProcess(this.container.getScriptCommandLine(uploadedDaemonScript));
            BufferedReader stdout = new BufferedReader(new InputStreamReader(daemonProcess.getStdout()));
            try {
                String stdoutLine;
                do {
                    if ((stdoutLine = stdout.readLine()) == null) {
                        throw new RuntimeIOException("Cannot start python daemon: lost connection to the python daemon");
                    }
                    context.logOutput(stdoutLine);
                } while (!stdoutLine.startsWith(DAEMON_STARTED));
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot start python daemon", (Throwable)exc);
            }
            wrappedProcess = new DaemonProcessWrapper(daemonConnection, daemonProcess);
            context.setAttribute(key, (Object)wrappedProcess);
        }
        return wrappedProcess;
    }

    private String generateDaemonScript() {
        StringBuilder b = new StringBuilder();
        b.append(this.loadScriptDir(STANDARD_RUNTIME_PATH));
        b.append(this.loadScriptDir(this.container.getRuntimePath()));
        b.append("#\nconnectFromDaemon()\n");
        b.append(this.loadScript(DAEMON_SCRIPT));
        b.append("#\ndisconnectFromDaemon()\n");
        return b.toString();
    }

    private String loadScript(String scriptPath) {
        URL scriptUrl = Thread.currentThread().getContextClassLoader().getResource(scriptPath);
        if (scriptUrl == null) {
            throw new IllegalArgumentException("Cannot load script from " + scriptPath + ": script does not exist on classpath");
        }
        try {
            TFile scriptFile = new TFile(new URI(scriptUrl.toString()));
            return this.loadScriptFromFile(scriptFile);
        }
        catch (URISyntaxException exc) {
            throw new RuntimeIOException("Cannot load script from " + scriptPath, (Throwable)exc);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot load script from " + scriptPath, (Throwable)exc);
        }
    }

    private String loadScriptDir(String scriptDirPath) {
        URL scriptDirUrl = Thread.currentThread().getContextClassLoader().getResource(scriptDirPath);
        if (scriptDirUrl == null) {
            throw new IllegalArgumentException("Cannot load scripts from " + scriptDirPath + ": script directory does not exist on classpath");
        }
        try {
            TFile scriptDir = new TFile(new URI(scriptDirUrl.toString()));
            TFile[] scriptDirFiles = scriptDir.listFiles();
            if (scriptDirFiles == null) {
                throw new IllegalArgumentException("Cannot load scripts from " + scriptDir + ": not a directory");
            }
            StringBuilder b = new StringBuilder();
            for (TFile scriptFile : scriptDirFiles) {
                b.append(this.loadScriptFromFile(scriptFile));
            }
            return b.toString();
        }
        catch (URISyntaxException exc) {
            throw new RuntimeIOException("Cannot read scripts from " + scriptDirPath, (Throwable)exc);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot read scripts from " + scriptDirPath, (Throwable)exc);
        }
    }

    protected String loadScriptFromFile(TFile scriptFile) throws FileNotFoundException {
        TFileReader scriptReader = new TFileReader(scriptFile);
        try {
            String string = "# " + scriptFile + "\n" + CharStreams.toString((Readable)scriptReader);
            return string;
        }
        catch (IOException exc) {
            throw new IllegalArgumentException("Cannot load script from " + scriptFile, exc);
        }
        finally {
            Closeables.closeQuietly((Closeable)scriptReader);
        }
    }

    private void dumpScript(String scriptName, String script) {
        if (logger.isDebugEnabled()) {
            logger.debug("::: " + scriptName);
            String[] lines = script.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                logger.debug(i + 1 + " : " + lines[i]);
            }
        }
    }

    protected OverthereFile uploadScript(OverthereConnection connection, String scriptFileNameTemplate, String scriptContents) {
        OverthereFile uploadedFile = connection.getTempFile(OverthereUtils.getName((String)scriptFileNameTemplate));
        OverthereUtils.write((String)scriptContents, (String)"UTF-8", (OverthereFile)uploadedFile);
        return uploadedFile;
    }

    String getScriptPath() {
        return this.scriptPath;
    }

    Map<String, Object> getPythonVars() {
        return this.pythonVars;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return PythonStep.class.getName() + "{" + "scriptName='" + this.scriptPath + "'}";
    }

    private static final class DaemonProcessWrapper
    implements ExecutionContextListener {
        private final OverthereConnection connection;
        private final OverthereProcess process;

        private DaemonProcessWrapper(OverthereConnection connection, OverthereProcess process) {
            this.connection = connection;
            this.process = process;
        }

        private OverthereConnection getConnection() {
            return this.connection;
        }

        private OverthereProcess getProcess() {
            return this.process;
        }

        public void contextDestroyed() {
            OutputStream stdin = this.process.getStdin();
            try {
                stdin.write("QUIT\r\n".getBytes());
                stdin.flush();
                this.process.waitFor();
            }
            catch (IOException exc) {
                logger.error("Error stopping python daemon", (Throwable)exc);
            }
            catch (RuntimeException exc) {
                logger.error("Error stopping python daemon", (Throwable)exc);
            }
            catch (InterruptedException exc) {
                logger.error("Error stopping python daemon", (Throwable)exc);
            }
            this.connection.close();
        }
    }
}

