/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.ExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.python.PythonVarsConverter;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class PythonStep<C extends ExecutionContext>
implements Step<C> {
    private static final String STANDARD_RUNTIME_PATH = "python/runtime";
    private static final String DAEMON_SCRIPT = "python/daemon/daemon.py";
    private static final String DAEMON_STARTED = "DEPLOYIT-DAEMON-STARTED";
    private static final String DAEMON_EXIT_CODE_MARKER = "DEPLOYIT-DAEMON-EXIT-VALUE: ";
    private static final String DAEMON_END_OF_COMMAND_MARKER = "DEPLOYIT-DAEMON-END-OF-COMMAND";
    private final PythonManagingContainer container;
    private final String scriptPath;
    private final Map<String, Object> pythonVars;
    private final String description;
    private boolean uploadArtifactData = true;
    private static final Logger logger = LoggerFactory.getLogger((String)PythonStep.class.getName());

    public PythonStep(PythonManagingContainer pythonManagingContainer, String string, Map<String, Object> map, String string2) {
        this.container = (PythonManagingContainer)Preconditions.checkNotNull((Object)pythonManagingContainer, (Object)"container is null");
        this.scriptPath = (String)Preconditions.checkNotNull((Object)string, (Object)"scriptPath is null");
        this.pythonVars = (Map)Preconditions.checkNotNull(map, (Object)"pythonVars is null");
        this.description = (String)Preconditions.checkNotNull((Object)string2, (Object)"description is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Step.Result doExecute(ExecutionContext executionContext) throws Exception {
        MDC.put((String)"scriptPath", (String)this.scriptPath);
        try {
            Step.Result result;
            OverthereConnection overthereConnection = this.container.getHost().getConnection();
            try {
                String string = this.aggregateScript(overthereConnection);
                ScriptUtils.dumpScript((String)OverthereUtils.getName((String)this.scriptPath), (String)string, (Logger)logger);
                OverthereFile overthereFile = ScriptUtils.uploadScript((OverthereConnection)overthereConnection, (String)this.scriptPath, (String)string);
                int n = this.executePythonScript(executionContext, overthereConnection, overthereFile);
                result = n == 0 ? Step.Result.Success : Step.Result.Fail;
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly((Closeable)overthereConnection);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)overthereConnection);
            return result;
        }
        finally {
            MDC.remove((String)"scriptPath");
        }
    }

    protected String aggregateScript(OverthereConnection overthereConnection) {
        String string = PythonVarsConverter.javaToPython(overthereConnection, this.pythonVars, this.uploadArtifactData);
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.container.runWithDaemon() || !overthereConnection.canStartProcess()) {
            stringBuilder.append(ScriptUtils.loadScriptDir((String)STANDARD_RUNTIME_PATH));
            stringBuilder.append(ScriptUtils.loadScriptDir((String)this.container.getRuntimePath()));
            if (this.container.hasProperty("runtimePaths")) {
                List list = (List)this.container.getProperty("runtimePaths");
                for (String string2 : list) {
                    stringBuilder.append(ScriptUtils.loadScriptDir((String)string2));
                }
            }
        }
        stringBuilder.append("# PythonVars\n");
        stringBuilder.append(string);
        if (!this.container.runWithDaemon() || !overthereConnection.canStartProcess()) {
            stringBuilder.append("#\nconnectFromStandAloneScript()\n");
        }
        stringBuilder.append(ScriptUtils.loadScript((String)this.scriptPath));
        if (!this.container.runWithDaemon() || !overthereConnection.canStartProcess()) {
            stringBuilder.append("#\ndisconnectFromStandAloneScript()\n");
        }
        return stringBuilder.toString();
    }

    private int executePythonScript(ExecutionContext executionContext, OverthereConnection overthereConnection, OverthereFile overthereFile) {
        if (this.container.runWithDaemon() && overthereConnection.canStartProcess()) {
            return this.executePythonScriptWithDaemon(executionContext, overthereFile);
        }
        return overthereConnection.execute((OverthereProcessOutputHandler)new ExecutionContextOverthereProcessOutputHandler(executionContext), this.container.getScriptCommandLine(overthereFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executePythonScriptWithDaemon(final ExecutionContext executionContext, OverthereFile overthereFile) {
        DaemonProcessWrapper daemonProcessWrapper = this.getDaemonProcess(executionContext);
        OverthereProcess overthereProcess = daemonProcessWrapper.getProcess();
        logger.info("Executing Python script {} on {}", (Object)overthereFile, (Object)daemonProcessWrapper.getConnection());
        String string = "runScriptFromDaemon(" + PythonVarsConverter.toPythonString(overthereFile.getPath()) + ")\n";
        OutputStream outputStream = overthereProcess.getStdin();
        outputStream.write(string.getBytes());
        outputStream.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(overthereProcess.getStdout()));
        final BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(overthereProcess.getStderr()));
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String string;
                    while (!Thread.interrupted() && (string = bufferedReader2.readLine()) != null) {
                        executionContext.logError(string);
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }, "stderr printer for python daemon running on " + this);
        thread.start();
        try {
            int n = 0;
            while (true) {
                String string2;
                if ((string2 = bufferedReader.readLine()) == null) {
                    throw new RuntimeIOException("Cannot execute script " + overthereFile.getPath() + " on " + this.container.getHost() + ": lost connection to the python daemon");
                }
                if (string2.startsWith(DAEMON_EXIT_CODE_MARKER)) {
                    try {
                        n = Integer.parseInt(string2.substring(DAEMON_EXIT_CODE_MARKER.length()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string2.equals(DAEMON_END_OF_COMMAND_MARKER)) break;
                executionContext.logOutput(string2);
            }
            int n2 = n;
            thread.interrupt();
            return n2;
        }
        catch (Throwable throwable) {
            try {
                thread.interrupt();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Cannot execute script " + overthereFile.getPath() + " on " + this.container.getHost(), (Throwable)iOException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DaemonProcessWrapper getDaemonProcess(ExecutionContext executionContext) {
        String string = "DAEMON_" + this.container.getId();
        DaemonProcessWrapper daemonProcessWrapper = (DaemonProcessWrapper)executionContext.getAttribute(string);
        if (daemonProcessWrapper == null) {
            executionContext.logOutput("Starting daemon on " + this.container.getHost());
            OverthereConnection overthereConnection = this.container.getHost().getConnection();
            String string2 = this.generateDaemonScript();
            ScriptUtils.dumpScript((String)"daemon.py", (String)string2, (Logger)logger);
            OverthereFile overthereFile = ScriptUtils.uploadScript((OverthereConnection)overthereConnection, (String)"daemon.py", (String)string2);
            OverthereProcess overthereProcess = overthereConnection.startProcess(this.container.getScriptCommandLine(overthereFile));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(overthereProcess.getStdout()));
            try {
                String string3;
                do {
                    if ((string3 = bufferedReader.readLine()) == null) {
                        throw new RuntimeIOException("Cannot start python daemon: lost connection to the python daemon");
                    }
                    executionContext.logOutput(string3);
                } while (!string3.startsWith(DAEMON_STARTED));
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Cannot start python daemon", (Throwable)iOException);
            }
            daemonProcessWrapper = new DaemonProcessWrapper(overthereConnection, overthereProcess);
            executionContext.setAttribute(string, (Object)daemonProcessWrapper);
        }
        return daemonProcessWrapper;
    }

    private String generateDaemonScript() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ScriptUtils.loadScriptDir((String)STANDARD_RUNTIME_PATH));
        stringBuilder.append(ScriptUtils.loadScriptDir((String)this.container.getRuntimePath()));
        if (this.container.hasProperty("runtimePaths")) {
            List list = (List)this.container.getProperty("runtimePaths");
            for (String string : list) {
                stringBuilder.append(ScriptUtils.loadScriptDir((String)string));
            }
        }
        stringBuilder.append("#\nconnectFromDaemon()\n");
        stringBuilder.append(ScriptUtils.loadScript((String)DAEMON_SCRIPT));
        stringBuilder.append("#\ndisconnectFromDaemon()\n");
        return stringBuilder.toString();
    }

    String getScriptPath() {
        return this.scriptPath;
    }

    Map<String, Object> getPythonVars() {
        return this.pythonVars;
    }

    public void setUploadArtifactData(boolean bl) {
        this.uploadArtifactData = bl;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return PythonStep.class.getName() + "{" + "scriptName='" + this.scriptPath + "'}";
    }

    private static final class DaemonProcessWrapper
    implements ExecutionContextListener {
        private final OverthereConnection connection;
        private final OverthereProcess process;

        private DaemonProcessWrapper(OverthereConnection overthereConnection, OverthereProcess overthereProcess) {
            this.connection = overthereConnection;
            this.process = overthereProcess;
        }

        private OverthereConnection getConnection() {
            return this.connection;
        }

        private OverthereProcess getProcess() {
            return this.process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contextDestroyed() {
            OutputStream outputStream = this.process.getStdin();
            try {
                outputStream.write("QUIT\r\n".getBytes());
                outputStream.flush();
                this.process.waitFor();
            }
            catch (IOException iOException) {
                logger.error("Error stopping python daemon", (Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                logger.error("Error stopping python daemon", (Throwable)runtimeException);
            }
            catch (InterruptedException interruptedException) {
                logger.error("Error stopping python daemon", (Throwable)interruptedException);
            }
            finally {
                Closeables.closeQuietly((Closeable)this.connection);
            }
        }
    }
}

