/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.AutoFlushingExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.python.PythonDaemon;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.python.PythonVarsConverter;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class PythonStep<C extends ExecutionContext>
implements Step<C> {
    static final String STANDARD_RUNTIME_PATH = "python/runtime";
    private final PythonManagingContainer container;
    private final String scriptPath;
    private final Map<String, Object> pythonVars;
    private final String description;
    private boolean uploadArtifactData = true;
    private static final Logger logger = LoggerFactory.getLogger(PythonStep.class);
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.python.scripts");

    public PythonStep(PythonManagingContainer pythonManagingContainer, String string, Map<String, Object> map, String string2) {
        this.container = (PythonManagingContainer)Preconditions.checkNotNull((Object)pythonManagingContainer, (Object)"container is null");
        this.scriptPath = (String)Preconditions.checkNotNull((Object)string, (Object)"scriptPath is null");
        this.pythonVars = (Map)Preconditions.checkNotNull(map, (Object)"pythonVars is null");
        this.description = (String)Preconditions.checkNotNull((Object)string2, (Object)"description is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Step.Result doExecute(ExecutionContext executionContext) throws Exception {
        MDC.put((String)"scriptPath", (String)this.scriptPath);
        try {
            Step.Result result;
            OverthereConnection overthereConnection = this.container.getHost().getConnection();
            try {
                String string = this.aggregateScript(overthereConnection);
                PythonStep.dumpPythonScript(OverthereUtils.getName((String)this.scriptPath), string);
                OverthereFile overthereFile = ScriptUtils.uploadScript((OverthereConnection)overthereConnection, (String)this.scriptPath, (String)string);
                int n = this.executePythonScript(executionContext, overthereConnection, overthereFile);
                result = n == 0 ? Step.Result.Success : Step.Result.Fail;
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly((Closeable)overthereConnection);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)overthereConnection);
            return result;
        }
        finally {
            MDC.remove((String)"scriptPath");
        }
    }

    protected String aggregateScript(OverthereConnection overthereConnection) {
        String string = PythonVarsConverter.javaToPython(overthereConnection, this.pythonVars, this.uploadArtifactData);
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.container.runWithDaemon() || !overthereConnection.canStartProcess()) {
            stringBuilder.append(ScriptUtils.loadScriptDir((String)STANDARD_RUNTIME_PATH));
            stringBuilder.append(ScriptUtils.loadScriptDir((String)this.container.getRuntimePath()));
        }
        stringBuilder.append("# PythonVars\n");
        stringBuilder.append(string);
        if (!this.container.runWithDaemon() || !overthereConnection.canStartProcess()) {
            stringBuilder.append("#\nconnectFromStandAloneScript()\n");
        }
        stringBuilder.append(ScriptUtils.loadScript((String)this.scriptPath));
        if (!this.container.runWithDaemon() || !overthereConnection.canStartProcess()) {
            stringBuilder.append("#\ndisconnectFromStandAloneScript()\n");
        }
        return stringBuilder.toString();
    }

    private int executePythonScript(ExecutionContext executionContext, OverthereConnection overthereConnection, OverthereFile overthereFile) {
        if (this.container.runWithDaemon() && overthereConnection.canStartProcess()) {
            return this.getDaemon(executionContext).executePythonScript(executionContext, overthereFile);
        }
        return this.executePythonScriptDirectly(executionContext, overthereConnection, overthereFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executePythonScriptDirectly(ExecutionContext executionContext, OverthereConnection overthereConnection, OverthereFile overthereFile) {
        logger.info("Executing Python script {} on {} (without daemon)", (Object)overthereFile, (Object)overthereConnection);
        AutoFlushingExecutionContextOverthereProcessOutputHandler autoFlushingExecutionContextOverthereProcessOutputHandler = new AutoFlushingExecutionContextOverthereProcessOutputHandler(executionContext);
        try {
            int n = overthereConnection.execute((OverthereProcessOutputHandler)autoFlushingExecutionContextOverthereProcessOutputHandler, this.container.getScriptCommandLine(overthereFile));
            return n;
        }
        finally {
            autoFlushingExecutionContextOverthereProcessOutputHandler.close();
        }
    }

    private PythonDaemon getDaemon(ExecutionContext executionContext) {
        String string = "DAEMON_" + this.container.getId();
        PythonDaemon pythonDaemon = (PythonDaemon)executionContext.getAttribute(string);
        if (pythonDaemon == null) {
            pythonDaemon = new PythonDaemon(this.container);
            pythonDaemon.start(executionContext);
            executionContext.setAttribute(string, (Object)pythonDaemon);
        }
        return pythonDaemon;
    }

    String getScriptPath() {
        return this.scriptPath;
    }

    Map<String, Object> getPythonVars() {
        return this.pythonVars;
    }

    public void setUploadArtifactData(boolean bl) {
        this.uploadArtifactData = bl;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return PythonStep.class.getName() + "{" + "scriptName='" + this.scriptPath + "'}";
    }

    public static void dumpPythonScript(String string, String string2) {
        ScriptUtils.dumpScript((String)string, (String)string2, (Logger)scriptsLogger);
    }
}

