package com.xebialabs.deployit.plugin.python;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.collect.Maps.newHashMap;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;

@SuppressWarnings("serial")
public abstract class PythonManagedDeployed<D extends Deployable, C extends PythonManagedContainer> extends BaseDeployed<D, C> {
	
	@Property(required = false, hidden = true, defaultValue = "false", description = "flag to indicate whether the deployed application CI is to be injected to the python script execution context.")
	private boolean exposeDeployedApplication;

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String scriptPath, String verb) {
        return addStep(ctx, order, scriptPath, verb, true);
    }

	protected boolean addStep(DeploymentPlanningContext ctx, int order, String scriptPath, String verb, boolean uploadArtifactData) {
		if (scriptPath != null) {
            PythonDeploymentStep step = new PythonDeploymentStep(order, getContainer().getManagingContainer(), scriptPath, getPythonVars(ctx.getDeployedApplication()), getDescription(verb));
            step.setUploadArtifactData(uploadArtifactData);
            ctx.addStep(step);
			return true;
		} else {
			return false;
		}
	}

	protected boolean addStep(InspectionPlanningContext ctx, String scriptPath, String verb) {
		if (scriptPath != null) {
			ctx.addStep(new PythonInspectionStep(this, getContainer().getManagingContainer(), scriptPath, getPythonVars(null), getDescription(verb)));
			return true;
		} else {
			return false;
		}
	}

	protected Map<String, Object> getPythonVars() {
		return getPythonVars(null);
	}

	protected Map<String, Object> getPythonVars(DeployedApplication deployedApplication) {
		Map<String, Object> pythonVars = newHashMap();
		pythonVars.put("deployed", this);
		if(exposeDeployedApplication) {
			checkNotNull(deployedApplication, "deployedApplication is null");
			pythonVars.put("deployedApplication", deployedApplication);
		}
		return pythonVars;
	}

	protected String getDescription(String verb) {
		return String.format("%s %s on %s", verb, getName(), getContainer().getName());
	}

	public boolean getExposeDeployedApplication() {
		return exposeDeployedApplication;
	}

	public void setExposeDeployedApplication(boolean exposeDeployedApplication) {
    	this.exposeDeployedApplication = exposeDeployedApplication;
    }

}
