/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.AutoFlushingExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.python.PythonDaemon;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.python.PythonVarsConverter;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class PythonStep<C extends ExecutionContext>
implements Step<C> {
    static final String STANDARD_RUNTIME_PATH = "python/runtime";
    private final PythonManagingContainer container;
    private final String scriptPath;
    private final Map<String, Object> pythonVars;
    private final String description;
    private boolean uploadArtifactData = true;
    private static final Logger logger = LoggerFactory.getLogger(PythonStep.class);
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.python.scripts");

    public PythonStep(PythonManagingContainer container, String scriptPath, Map<String, Object> pythonVars, String description) {
        this.container = (PythonManagingContainer)Preconditions.checkNotNull((Object)container, (Object)"container is null");
        this.scriptPath = (String)Preconditions.checkNotNull((Object)scriptPath, (Object)"scriptPath is null");
        this.pythonVars = (Map)Preconditions.checkNotNull(pythonVars, (Object)"pythonVars is null");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Step.Result doExecute(ExecutionContext ctx) throws Exception {
        MDC.put((String)"scriptPath", (String)this.scriptPath);
        try {
            OverthereConnection conn;
            block8: {
                Step.Result result;
                conn = this.container.getHost().getConnection();
                try {
                    String finalScript = this.aggregateScript(conn);
                    PythonStep.dumpPythonScript(OverthereUtils.getName((String)this.scriptPath), finalScript);
                    OverthereFile uploadedScriptFile = ScriptUtils.uploadScript((OverthereConnection)conn, (String)this.scriptPath, (String)finalScript);
                    int res = this.executePythonScript(ctx, conn, uploadedScriptFile);
                    logger.debug("Exit code: {}", (Object)res);
                    if (res != 0) break block8;
                    result = Step.Result.Success;
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly((Closeable)conn);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)conn);
                return result;
            }
            Step.Result result = Step.Result.Fail;
            Closeables.closeQuietly((Closeable)conn);
            return result;
        }
        finally {
            MDC.remove((String)"scriptPath");
        }
    }

    protected String aggregateScript(OverthereConnection connection) {
        String pythonVarsPython = PythonVarsConverter.javaToPython(connection, this.pythonVars, this.uploadArtifactData);
        StringBuilder b = new StringBuilder();
        if (!this.container.runWithDaemon() || !connection.canStartProcess()) {
            b.append(ScriptUtils.loadScriptDir((String)STANDARD_RUNTIME_PATH));
            b.append(ScriptUtils.loadScriptDir((String)this.container.getRuntimePath()));
        }
        b.append("# PythonVars\n");
        b.append(pythonVarsPython);
        if (!this.container.runWithDaemon() || !connection.canStartProcess()) {
            b.append("#\nconnectFromStandAloneScript()\n");
        }
        b.append(ScriptUtils.loadScript((String)this.scriptPath));
        if (!this.container.runWithDaemon() || !connection.canStartProcess()) {
            b.append("#\ndisconnectFromStandAloneScript()\n");
        }
        return b.toString();
    }

    private int executePythonScript(ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        if (this.container.runWithDaemon() && conn.canStartProcess()) {
            return this.getDaemon(ctx).executePythonScript(ctx, script);
        }
        return this.executePythonScriptDirectly(ctx, conn, script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executePythonScriptDirectly(ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        logger.info("Executing Python script {} on {} (without daemon)", (Object)script, (Object)conn);
        AutoFlushingExecutionContextOverthereProcessOutputHandler handler = new AutoFlushingExecutionContextOverthereProcessOutputHandler(ctx);
        try {
            int n = conn.execute((OverthereProcessOutputHandler)handler, this.container.getScriptCommandLine(script));
            return n;
        }
        finally {
            handler.close();
        }
    }

    private PythonDaemon getDaemon(ExecutionContext context) {
        String key = "DAEMON_" + this.container.getId();
        PythonDaemon daemon = (PythonDaemon)context.getAttribute(key);
        if (daemon == null) {
            daemon = new PythonDaemon(this.container);
            daemon.start(context);
            context.setAttribute(key, (Object)daemon);
        }
        return daemon;
    }

    String getScriptPath() {
        return this.scriptPath;
    }

    Map<String, Object> getPythonVars() {
        return this.pythonVars;
    }

    public void setUploadArtifactData(boolean uploadArtifactData) {
        this.uploadArtifactData = uploadArtifactData;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return PythonStep.class.getName() + "{" + "scriptName='" + this.scriptPath + "'}";
    }

    public static void dumpPythonScript(String scriptName, String scriptContents) {
        ScriptUtils.dumpScript((String)scriptName, (String)scriptContents, (Logger)scriptsLogger);
    }
}

