/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import java.io.Closeable;
import org.apache.commons.io.IOUtils;

public class CheckCommandExecutionStep
implements Step {
    private Host host;
    private String hostname;

    public CheckCommandExecutionStep(Host host) {
        this.host = host;
        this.hostname = host.hasProperty("address") ? (String)host.getProperty("address") : host.getName();
    }

    public String getDescription() {
        return "Check whether XL Deploy can execute commands on " + this.hostname;
    }

    public int getOrder() {
        return 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        DefaultExecutionOutputHandler stdoutHandler = DefaultExecutionOutputHandler.handleStdout(ctx);
        DefaultExecutionOutputHandler stderrHandler = DefaultExecutionOutputHandler.handleStderr(ctx);
        try {
            OverthereConnection connection;
            block9: {
                connection = this.host.getConnection();
                ctx.logOutput("Listing the contents of the temporary directory...");
                int i = this.echoTmpDirContents(connection, stdoutHandler, stderrHandler);
                if (i == 0) break block9;
                ctx.logError("Failed to execute command on " + this.hostname + ". Return code was [" + i + "]. Please check the logs.");
                StepExitCode stepExitCode = StepExitCode.FAIL;
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly((Closeable)connection);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)connection);
                return stepExitCode;
            }
            try {
                IOUtils.closeQuietly((Closeable)connection);
            }
            catch (Exception exc) {
                ctx.logError("Cannot execute commands on " + this.hostname + ". Please check the connection settings.", (Throwable)exc);
                StepExitCode stepExitCode = StepExitCode.FAIL;
                return stepExitCode;
            }
            ctx.logOutput("Succesfully executed commands on " + this.hostname + ".");
            StepExitCode stepExitCode = StepExitCode.SUCCESS;
            return stepExitCode;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stdoutHandler);
            IOUtils.closeQuietly((Closeable)stderrHandler);
        }
    }

    private int echoTmpDirContents(OverthereConnection connection, OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler) {
        CmdLine cmdLine = new CmdLine();
        if (connection.getHostOperatingSystem() == OperatingSystemFamily.WINDOWS) {
            cmdLine.addArgument("cmd");
            cmdLine.addArgument("/c");
            cmdLine.addArgument("dir");
        } else {
            cmdLine.addArgument("ls");
        }
        String tempDir = this.host.getTemporaryDirectoryPath();
        if (tempDir == null) {
            tempDir = connection.getHostOperatingSystem().getDefaultTemporaryDirectoryPath();
        }
        cmdLine.addArgument(tempDir);
        return connection.execute(stdoutHandler, stderrHandler, cmdLine);
    }
}

