/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.remoting.scripts;

import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptUtils {
    public static final String MDC_KEY_SCRIPT_PATH = "scriptPath";
    public static final ByteOrderMark[] detectedBOMs = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE};
    private static final Logger logger = LoggerFactory.getLogger(ScriptUtils.class);

    public static void appendScripts(List<String> scriptPaths, StringBuilder b) {
        for (String s : scriptPaths) {
            ScriptUtils.appendScript(s, b);
        }
    }

    public static void appendScript(String scriptPath, StringBuilder b) {
        b.append(ScriptUtils.loadScript(scriptPath));
    }

    public static void appendScriptDir(String scriptDirPath, StringBuilder b) {
        b.append(ScriptUtils.loadScriptDir(scriptDirPath));
    }

    public static String loadScript(String scriptPath) {
        String string;
        logger.debug("Loading script from [{}]", (Object)scriptPath);
        URL scriptUrl = Thread.currentThread().getContextClassLoader().getResource(scriptPath);
        if (scriptUrl == null) {
            throw new IllegalArgumentException("Cannot load script from " + scriptPath + ": script does not exist on classpath");
        }
        TFile scriptFile = null;
        try {
            scriptFile = new TFile(new URI(scriptUrl.toString()));
            string = ScriptUtils.loadScriptFromFile(scriptFile);
        }
        catch (IOException | URISyntaxException exc) {
            try {
                throw new RuntimeIOException("Cannot load script from " + scriptPath, (Throwable)exc);
            }
            catch (Throwable throwable) {
                ScriptUtils.umountQuietly(scriptFile);
                throw throwable;
            }
        }
        ScriptUtils.umountQuietly(scriptFile);
        return string;
    }

    public static String loadScriptDir(String scriptDirPath) {
        String string;
        if (scriptDirPath == null || scriptDirPath.length() == 0) {
            return "";
        }
        logger.debug("Loading scripts from [{}]", (Object)scriptDirPath);
        URL scriptDirUrl = Thread.currentThread().getContextClassLoader().getResource(scriptDirPath);
        if (scriptDirUrl == null) {
            throw new IllegalArgumentException("Cannot load scripts from " + scriptDirPath + ": script directory does not exist on classpath");
        }
        TFile scriptDir = null;
        try {
            scriptDir = new TFile(new URI(scriptDirUrl.toString()));
            TFile[] scriptDirFiles = scriptDir.listFiles();
            if (scriptDirFiles == null) {
                throw new IllegalArgumentException("Cannot load scripts from " + scriptDir + ": not a directory");
            }
            StringBuilder b = new StringBuilder();
            for (TFile scriptFile : scriptDirFiles) {
                b.append(ScriptUtils.loadScriptFromFile(scriptFile));
            }
            string = b.toString();
        }
        catch (IOException | URISyntaxException exc) {
            try {
                throw new RuntimeIOException("Cannot read scripts from " + scriptDirPath, (Throwable)exc);
            }
            catch (Throwable throwable) {
                ScriptUtils.umountQuietly(scriptDir);
                throw throwable;
            }
        }
        ScriptUtils.umountQuietly(scriptDir);
        return string;
    }

    /*
     * Exception decompiling
     */
    public static String loadScriptFromFile(TFile scriptFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Reader createScriptReader(TFile scriptFile, BOMInputStream scriptInputStream) throws IOException {
        InputStreamReader scriptReader;
        if (scriptInputStream.hasBOM()) {
            String charsetName = scriptInputStream.getBOMCharsetName();
            logger.debug("Reading script from [{}] with encoding [{}]", (Object)scriptFile, (Object)charsetName);
            Charset charset = Charset.forName(charsetName);
            scriptReader = new InputStreamReader((InputStream)scriptInputStream, charset);
        } else {
            logger.debug("Reading script from [{}] with default platform encoding", (Object)scriptFile);
            scriptReader = new InputStreamReader((InputStream)scriptInputStream);
        }
        return scriptReader;
    }

    public static void dumpScript(String scriptTemplateName, String evaluatedScriptContents, Logger logger) {
        if (logger.isTraceEnabled()) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            logger.trace(":::: " + df.format(new Date()) + " :::: " + scriptTemplateName + " ::::");
            String[] lines = evaluatedScriptContents.split("\r?\n");
            for (int i = 0; i < lines.length; ++i) {
                logger.trace(i + 1 + " : " + lines[i]);
            }
        }
    }

    public static OverthereFile uploadScript(OverthereConnection connection, String scriptFileNameTemplate, String scriptContents) {
        OverthereFile uploadedFile = connection.getTempFile(OverthereUtils.getName((String)scriptFileNameTemplate));
        OverthereUtils.write((String)scriptContents, (String)"UTF-8", (OverthereFile)uploadedFile);
        return uploadedFile;
    }

    static void umountQuietly(TFile file) {
        if (file != null && file.isArchive() && file.getEnclArchive() == null) {
            try {
                TFile.umount((TFile)file);
            }
            catch (Exception e) {
                logger.error("Couldn't umount [{}], ignoring exception.", (Object)file);
                logger.debug("Exception while umounting was: ", (Throwable)e);
            }
        }
    }
}

