/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import ai.digital.deploy.sql.model.LoginProvider;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.platform.sso.oidc.authentication.CustomOidcIdTokenDecoderFactory;
import com.xebialabs.platform.sso.oidc.exceptions.UnsupportedOidcConfigurationException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.GrantedAuthoritiesExtractor;
import com.xebialabs.platform.sso.oidc.service.XLOidcUserService;
import com.xebialabs.platform.sso.oidc.web.CustomAuthorizationRequestResolver;
import com.xebialabs.platform.sso.oidc.web.OidcLogoutSuccessHandler;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xldeploy.authentication.oidc.conf.OpenIdConnectConfig$;
import com.xebialabs.xldeploy.authentication.oidc.policy.impl.OidcUserProfileCreationPolicy;
import com.xebialabs.xlplatform.config.ConfigLoader$;
import com.xebialabs.xlplatform.config.ConfigurationHolder$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Marker;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.NimbusJwtClientAuthenticationParametersConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.FunctionConverters$;
import scala.jdk.FunctionWrappers;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

@ConditionalOnProperty(name={"deploy.server.security.auth.provider"}, havingValue="oidc")
@EnableWebSecurity
@Configuration
@ComponentScan(value={"com.xebialabs.xldeploy.auth.oidc.config"})
@ScalaSignature(bytes="\u0006\u0005\ruv!B\u00181\u0011\u0003id!B 1\u0011\u0003\u0001\u0005\"B$\u0002\t\u0003A\u0005bB%\u0002\u0005\u0004%\tA\u0013\u0005\u0007S\u0006\u0001\u000b\u0011B&\t\u000f)\f!\u0019!C\u0001W\"1\u00110\u0001Q\u0001\n1DqA_\u0001C\u0002\u0013\u00051\u0010C\u0004\u0002\u0004\u0005\u0001\u000b\u0011\u0002?\t\u0011\u0005\u0015\u0011A1A\u0005\u0002mDq!a\u0002\u0002A\u0003%APB\u0003@a\u0001\tI\u0001\u0003\u0004H\u0017\u0011\u0005\u00111\u0004\u0005\b\u0003?YA\u0011AA\u0011\u0011\u001d\tYd\u0003C\u0001\u0003{Aq!!\u0018\f\t\u0003\ti\u0004C\u0004\u0002b-!\t!a\u0019\t\u000f\u0005]4\u0002\"\u0001\u0002z!9\u0011qS\u0006\u0005\u0002\u0005e\u0005bBAY\u0017\u0011\u0005\u00111\u0017\u0005\b\u0003\u0003\\A\u0011AAb\u0011\u001d\tin\u0003C\u0001\u0003?Dq!!>\f\t\u0003\t9\u0010C\u0004\u0003\u000e-!\tAa\u0004\t\u000f\te1\u0002\"\u0001\u0003\u001c!9!\u0011G\u0006\u0005\u0002\tM\u0002\"\u0003B#\u0017\t\u0007I\u0011\u0001B$\u0011!\u0011)f\u0003Q\u0001\n\t%\u0003b\u0002B,\u0017\u0011\u0005!\u0011\f\u0005\b\u0005SZA\u0011\u0001B6\u0011\u001d\u0011)h\u0003C\u0001\u0005oBqAa!\f\t\u0003\u0011)\tC\u0004\u0003\u0010.!\tA!%\t\u000f\t\u00056\u0002\"\u0003\u0003$\"9!QU\u0006\u0005\n\t\u001d\u0006b\u0002B\\\u0017\u0011%!\u0011\u0018\u0005\b\u0005\u0013\\A\u0011\u0002Bf\u0011\u001d\u0011)n\u0003C\u0005\u0005/DqAa8\f\t\u0013\u0011\t\u000fC\u0004\u0003p.!IA!=\t\u000f\t}8\u0002\"\u0003\u0004\u0002!91qB\u0006\u0005\n\rE\u0001bBB\r\u0017\u0011%11\u0004\u0005\b\u0007_YA\u0011BB\u0019\u0011\u001d\u0019)d\u0003C\u0005\u0007oAqaa\u0011\f\t\u0013\u0019)\u0005C\u0004\u0004\\-!Ia!\u0018\u0002'=\u0003XM\\%e\u0007>tg.Z2u\u0007>tg-[4\u000b\u0005E\u0012\u0014\u0001B2p]\u001aT!a\r\u001b\u0002\t=LGm\u0019\u0006\u0003kY\na\"Y;uQ\u0016tG/[2bi&|gN\u0003\u00028q\u0005A\u0001\u0010\u001c3fa2|\u0017P\u0003\u0002:u\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002w\u0005\u00191m\\7\u0004\u0001A\u0011a(A\u0007\u0002a\t\u0019r\n]3o\u0013\u0012\u001cuN\u001c8fGR\u001cuN\u001c4jON\u0011\u0011!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0014!F'B\u0007~\u000bEjR(S\u0013RCUjX'B!BKejR\u000b\u0002\u0017B!Aj\u0015,g\u001d\ti\u0015\u000b\u0005\u0002O\u00076\tqJ\u0003\u0002Qy\u00051AH]8pizJ!AU\"\u0002\rA\u0013X\rZ3g\u0013\t!VKA\u0002NCBT!AU\"\u0011\u0005]#W\"\u0001-\u000b\u0005eS\u0016a\u00016xg*\u00111\fX\u0001\u0005U>\u001cXM\u0003\u0002^=\u00061q.Y;uQJR!a\u00181\u0002\u0011M,7-\u001e:jifT!!\u00192\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aY\u0001\u0004_J<\u0017BA3Y\u00051i\u0015mY!mO>\u0014\u0018\u000e\u001e5n!\tau-\u0003\u0002i+\n11\u000b\u001e:j]\u001e\fa#T!D?\u0006cui\u0014*J)\"ku,T!Q!&su\tI\u0001\u001c\u000bN\u000bu,\u0011'H\u001fJKE\u000bS'`\u0007V\u0013f+R0N\u0003B\u0003\u0016JT$\u0016\u00031\u0004B\u0001T*naB\u0011qK\\\u0005\u0003_b\u0013ABS<t\u00032<wN]5uQ6\u0004\"!]<\u000e\u0003IT!a\u001d;\u0002\u0007)<8N\u0003\u0002\\k*\u0011aOO\u0001\t]&l'-^:eg&\u0011\u0001P\u001d\u0002\u0006\u0007V\u0014h/Z\u0001\u001d\u000bN\u000bu,\u0011'H\u001fJKE\u000bS'`\u0007V\u0013f+R0N\u0003B\u0003\u0016JT$!\u0003E)5+Q0B\u0019\u001e{%+\u0013+I\u001b~k\u0015\tU\u000b\u0002yB!AjU7~!\tqx0D\u0001u\u0013\r\t\t\u0001\u001e\u0002\r\u0015^\u001b\u0016\t\\4pe&$\b.\\\u0001\u0013\u000bN\u000bu,\u0011'H\u001fJKE\u000bS'`\u001b\u0006\u0003\u0006%A\tS'\u0006{\u0016\tT$P%&#\u0006*T0N\u0003B\u000b!CU*B?\u0006cui\u0014*J)\"ku,T!QAM!1\"QA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\tQa\u001d7gi)T!!!\u0006\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012LA!!\u0007\u0002\u0010\t9Aj\\4hS:<GCAA\u000f!\tq4\"\u0001\u0006pS\u0012\u001c7i\u001c8gS\u001e,\"!a\t\u0011\u0007y\n)#C\u0002\u0002(A\u0012!bT5eG\u000e{gNZ5hQ\ri\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003)\tgN\\8uCRLwN\u001c\u0006\u0004\u0003k\u0001\u0017aB2p]R,\u0007\u0010^\u0005\u0005\u0003s\tyC\u0001\u0003CK\u0006t\u0017!E8jI\u000edunZ5o!J|g/\u001b3feV\u0011\u0011q\b\t\u0005\u0003\u0003\n9&\u0004\u0002\u0002D)!\u0011QIA$\u0003\u0015iw\u000eZ3m\u0015\u0011\tI%a\u0013\u0002\u0007M\fHN\u0003\u0003\u0002N\u0005=\u0013A\u00023fa2|\u0017P\u0003\u0003\u0002R\u0005M\u0013a\u00023jO&$\u0018\r\u001c\u0006\u0003\u0003+\n!!Y5\n\t\u0005e\u00131\t\u0002\u000e\u0019><\u0017N\u001c)s_ZLG-\u001a:)\u00079\tY#\u0001\nm_\u000e\fG\u000eT8hS:\u0004&o\u001c<jI\u0016\u0014\bfA\b\u0002,\u0005a2\r\\5f]R\u0014VmZ5tiJ\fG/[8o%\u0016\u0004xn]5u_JLXCAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\nAB]3hSN$(/\u0019;j_:T1!a\u001c]\u0003\u0019\u0019G.[3oi&!\u00111OA5\u0005\u0011Je.T3n_JL8\t\\5f]R\u0014VmZ5tiJ\fG/[8o%\u0016\u0004xn]5u_JL\bf\u0001\t\u0002,\u0005\u00013\r\\1j[N$vn\u0012:b]R,G-Q;uQ>\u0014\u0018\u000e^5fgB{G.[2z+\t\tY\b\u0005\u0003\u0002~\u0005EUBAA@\u0015\u0011\t\t)a!\u0002\t%l\u0007\u000f\u001c\u0006\u0005\u0003\u000b\u000b9)\u0001\u0004q_2L7-\u001f\u0006\u0004g\u0005%%\u0002BAF\u0003\u001b\u000b1a]:p\u0015\r\ty\tO\u0001\ta2\fGOZ8s[&!\u00111SA@\u0005\u001d\"UMZ1vYR\u001cE.Y5ngR{wI]1oi\u0016$\u0017)\u001e;i_JLG/[3t!>d\u0017nY=)\u0007E\tY#\u0001\u0012dkN$x.\\!vi\"|'/\u001b>bi&|gNU3rk\u0016\u001cHOU3t_24XM\u001d\u000b\u0005\u00037\u000b9\u000b\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\u0011\t\t+a\"\u0002\u0007],'-\u0003\u0003\u0002&\u0006}%AI\"vgR|W.Q;uQ>\u0014\u0018N_1uS>t'+Z9vKN$(+Z:pYZ,'\u000fC\u0004\u0002bI\u0001\r!!+\u0011\t\u0005\u001d\u00141V\u0005\u0005\u0003[\u000bIG\u0001\u000fDY&,g\u000e\u001e*fO&\u001cHO]1uS>t'+\u001a9pg&$xN]=)\u0007I\tY#A\fbkRDwN]5{K\u0012\u001cE.[3oiN+'O^5dKR!\u0011QWA_!\u0011\t9,!/\u000e\u0005\u00055\u0014\u0002BA^\u0003[\u0012Q%\u00138NK6|'/_(BkRD''Q;uQ>\u0014\u0018N_3e\u00072LWM\u001c;TKJ4\u0018nY3\t\u000f\u0005\u00054\u00031\u0001\u0002*\"\u001a1#a\u000b\u0002#adw*\u001b3d+N,'oU3sm&\u001cW\r\u0006\u0003\u0002F\u0006E\u0007\u0003BAd\u0003\u001bl!!!3\u000b\t\u0005-\u0017qQ\u0001\bg\u0016\u0014h/[2f\u0013\u0011\ty-!3\u0003#acu*\u001b3d+N,'oU3sm&\u001cW\rC\u0004\u0002xQ\u0001\r!a5\u0011\t\u0005U\u0017q[\u0007\u0003\u0003\u0007KA!!7\u0002\u0004\n\u00013\t\\1j[N$vn\u0012:b]R,G-Q;uQ>\u0014\u0018\u000e^5fgB{G.[2zQ\r!\u00121F\u0001\u001bCV$\bn\u001c:ju\u0016$7\t\\5f]R\u0014V\r]8tSR|'/\u001f\u000b\u0005\u0003C\fY\u000f\u0005\u0003\u0002d\u0006\u001dXBAAs\u0015\u0011\t\t+!\u001c\n\t\u0005%\u0018Q\u001d\u00027\u0003V$\b.\u001a8uS\u000e\fG/\u001a3Qe&t7-\u001b9bY>\u000bU\u000f\u001e53\u0003V$\bn\u001c:ju\u0016$7\t\\5f]R\u0014V\r]8tSR|'/\u001f\u0005\b\u0003c+\u0002\u0019AAw!\u0011\t9,a<\n\t\u0005E\u0018Q\u000e\u0002\u001e\u001f\u0006+H\u000f\u001b\u001aBkRDwN]5{K\u0012\u001cE.[3oiN+'O^5dK\"\u001aQ#a\u000b\u0002+%$Gk\\6f]\u0012+7m\u001c3fe\u001a\u000b7\r^8ssV\u0011\u0011\u0011 \t\u0007\u0003w\u0014\tA!\u0002\u000e\u0005\u0005u(bAA\u00009\u0006\u0019!n\u001e;\n\t\t\r\u0011Q \u0002\u0012\u0015^$H)Z2pI\u0016\u0014h)Y2u_JL\b\u0003BA4\u0005\u000fIAA!\u0003\u0002j\t\u00112\t\\5f]R\u0014VmZ5tiJ\fG/[8oQ\r1\u00121F\u0001\u000bU^$H)Z2pI\u0016\u0014XC\u0001B\t!\u0011\tYPa\u0005\n\t\tU\u0011Q \u0002\u000b\u0015^$H)Z2pI\u0016\u0014\bfA\f\u0002,\u0005Q\"n\u001e;BkRDWM\u001c;jG\u0006$\u0018n\u001c8D_:4XM\u001d;feV\u0011!Q\u0004\t\u0005\u0005?\u0011Y#\u0004\u0002\u0003\")\u0019QGa\t\u000b\t\t\u0015\"qE\u0001\te\u0016\u001cx.\u001e:dK*\u0019!\u0011\u0006/\u0002\rM,'O^3s\u0013\u0011\u0011iC!\t\u00035);H/Q;uQ\u0016tG/[2bi&|gnQ8om\u0016\u0014H/\u001a:)\u0007a\tY#\u0001\u0013bkRDwN]5{CRLwN\\\"pI\u0016$vn[3o%\u0016\u001c\bo\u001c8tK\u000ec\u0017.\u001a8u)\u0011\u0011)D!\u0011\u0011\t\t]\"QH\u0007\u0003\u0005sQAAa\u000f\u0002n\u0005AQM\u001c3q_&tG/\u0003\u0003\u0003@\te\"a\u000b#fM\u0006,H\u000e^!vi\"|'/\u001b>bi&|gnQ8eKR{7.\u001a8SKN\u0004xN\\:f\u00072LWM\u001c;\t\u000f\u0005\u0005\u0014\u00041\u0001\u0002*\"\u001a\u0011$a\u000b\u0002\u0017)<8NU3t_24XM]\u000b\u0003\u0005\u0013\u0002rA\u0011B&\u0005\u000b\u0011y%C\u0002\u0003N\r\u0013\u0011BR;oGRLwN\\\u0019\u0011\u0007E\u0014\t&C\u0002\u0003TI\u00141AS,L\u00031Qwo\u001b*fg>dg/\u001a:!\u0003]y\u0017\u000eZ2M_\u001eLgNR1jYV\u0014X\rS1oI2,'/\u0006\u0002\u0003\\A!!Q\fB2\u001b\t\u0011yFC\u00026\u0005CR1!!)_\u0013\u0011\u0011)Ga\u0018\u00039\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u000bg\u000e\u001a7fe\"\u001aA$a\u000b\u0002-adG\rT8hS:4\u0015-\u001b7ve\u0016D\u0015M\u001c3mKJ,\"A!\u001c\u0011\t\tu#qN\u0005\u0005\u0005c\u0012yFA\u0013TS6\u0004H.Z+sY\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u000bg\u000e\u001a7fe\"\u001aQ$a\u000b\u00025=\u0004XM\\%e\u0019><w.\u001e;Tk\u000e\u001cWm]:IC:$G.\u001a:\u0015\t\te$q\u0010\t\u0005\u0003;\u0013Y(\u0003\u0003\u0003~\u0005}%\u0001G(jI\u000edunZ8viN+8mY3tg\"\u000bg\u000e\u001a7fe\"9\u0011\u0011\r\u0010A\u0002\u0005%\u0006f\u0001\u0010\u0002,\u0005\u0001Cn\\4j]V\u0013H.Q;uQ\u0016tG/[2bi&|g.\u00128uef\u0004v.\u001b8u+\t\u00119\t\u0005\u0003\u0003^\t%\u0015\u0002\u0002BF\u0005?\u0012\u0001\u0005T8hS:,&\u000f\\!vi\",g\u000e^5dCRLwN\\#oiJL\bk\\5oi\"\u001aq$a\u000b\u0002;=LGmY+tKJ\u0004&o\u001c4jY\u0016\u001c%/Z1uS>t\u0007k\u001c7jGf,\"Aa%\u0011\t\tU%1T\u0007\u0003\u0005/SA!!!\u0003\u001a*\u0019\u0011Q\u0011\u001a\n\t\tu%q\u0013\u0002\u001e\u001f&$7-V:feB\u0013xNZ5mK\u000e\u0013X-\u0019;j_:\u0004v\u000e\\5ds\"\u001a\u0001%a\u000b\u0002%\rd\u0017.\u001a8u%\u0016<\u0017n\u001d;sCRLwN\\\u000b\u0003\u0005\u000b\tAdZ3u\u00072LWM\u001c;SK\u001eL7\u000f\u001e:bi&|gNQ;jY\u0012,'/\u0006\u0002\u0003*B!!1\u0016BY\u001d\u0011\t9G!,\n\t\t=\u0016\u0011N\u0001\u0013\u00072LWM\u001c;SK\u001eL7\u000f\u001e:bi&|g.\u0003\u0003\u00034\nU&a\u0002\"vS2$WM\u001d\u0006\u0005\u0005_\u000bI'\u0001\rdY&,g\u000e\u001e%uiB\u0014V-];fgR4\u0015m\u0019;pef,\"Aa/\u0011\t\tu&QY\u0007\u0003\u0005\u007fSA!a\u001c\u0003B*\u0019!1\u00191\u0002\t!$H\u000f]\u0005\u0005\u0005\u000f\u0014yL\u0001\rDY&,g\u000e\u001e%uiB\u0014V-];fgR4\u0015m\u0019;pef\fqbZ3u\u0015^\u001c\u0018\t\\4pe&$\b.\u001c\u000b\u0006[\n5'\u0011\u001b\u0005\u0007\u0005\u001f$\u0003\u0019\u00014\u0002\u0019)<8/\u00117h_JLG\u000f[7\t\r\tMG\u00051\u0001g\u00031\u0001(o\u001c9feRLh*Y7f\u0003=9W\r^'bG\u0006cwm\u001c:ji\"lG#\u0002,\u0003Z\nu\u0007B\u0002BnK\u0001\u0007a-\u0001\u0007nC\u000e\fEnZ8sSRDW\u000e\u0003\u0004\u0003T\u0016\u0002\rAZ\u0001\u0016O\u0016$8+[4oCR,(/Z!mO>\u0014\u0018\u000e\u001e5n)\u0019\u0011\u0019O!;\u0003nB\u0019qK!:\n\u0007\t\u001d\bL\u0001\nTS\u001et\u0017\r^;sK\u0006cwm\u001c:ji\"l\u0007B\u0002BvM\u0001\u0007a-\u0001\ntS\u001et\u0017\r^;sK\u0006cwm\u001c:ji\"l\u0007B\u0002BjM\u0001\u0007a-A\nhKR\u001cE.[3oi\u0006+H\u000f['fi\"|G-\u0006\u0002\u0003tB!!Q\u001fB~\u001b\t\u00119PC\u0002\u0003zr\u000bAaY8sK&!!Q B|\u0005i\u0019E.[3oi\u0006+H\u000f[3oi&\u001c\u0017\r^5p]6+G\u000f[8e\u0003i9W\r\u001e&xi>\u000bU\u000f\u001e53)>\\WM\u001c,bY&$\u0017\r^8s+\t\u0019\u0019\u0001\u0005\u0004\u0003v\u000e\u00151\u0011B\u0005\u0005\u0007\u000f\u00119P\u0001\u000bP\u0003V$\bN\r+pW\u0016tg+\u00197jI\u0006$xN\u001d\t\u0005\u0003w\u001cY!\u0003\u0003\u0004\u000e\u0005u(a\u0001&xi\u0006Ib/\u00197jI\u0006$XmT5eG\u000e{gNZ5hkJ\fG/[8o)\t\u0019\u0019\u0002E\u0002C\u0007+I1aa\u0006D\u0005\u0011)f.\u001b;\u0002;\u001d,G/\u0012:s_JlUm]:bO\u00164uN\u001d)mC\u000e,\u0007n\u001c7eKJ$Ba!\b\u0004,A!1qDB\u0015\u001b\t\u0019\tC\u0003\u0003\u0004$\r\u0015\u0012\u0001\u00027b]\u001eT!aa\n\u0002\t)\fg/Y\u0005\u0004Q\u000e\u0005\u0002BBB\u0017U\u0001\u0007a-A\u0006qY\u0006\u001cW\r[8mI\u0016\u0014\u0018AB:fi*;8\u000e\u0006\u0003\u0004\u0014\rM\u0002b\u0002BQW\u0001\u0007!QA\u0001\u000bO\u0016$8*Z=QC&\u0014XCAB\u001d!\u0011\u0019Yda\u0010\u000e\u0005\ru\"bA0\u0004&%!1\u0011IB\u001f\u0005\u001dYU-\u001f)bSJ\f\u0011bZ3u%N\u000b5*Z=\u0015\r\r\u001d3QJB)!\r\t8\u0011J\u0005\u0004\u0007\u0017\u0012(A\u0002*T\u0003.+\u0017\u0010C\u0004\u0004P5\u0002\ra!\u000f\u0002\u000f-,\u0017\u0010U1je\"911K\u0017A\u0002\rU\u0013!C1mO>\u0014\u0018\u000e\u001e5n!\rq8qK\u0005\u0004\u00073\"(!C!mO>\u0014\u0018\u000e\u001e5n\u0003%9W\r^#T\u0003.+\u0017\u0010\u0006\u0005\u0004`\r\u00154qMB5!\r\t8\u0011M\u0005\u0004\u0007G\u0012(!B#D\u0017\u0016L\bbBB(]\u0001\u00071\u0011\b\u0005\b\u0007'r\u0003\u0019AB+\u0011\u0019\u0019YG\fa\u0001a\u0006)1-\u001e:wK\"Z1ba\u001c\u0004\u0004\u000e\u001551RBG!\u0011\u0019\tha \u000e\u0005\rM$\u0002BB;\u0007o\n\u0011bY8oI&$\u0018n\u001c8\u000b\t\re41P\u0001\u000eCV$xnY8oM&<WO]3\u000b\u0007\ru\u0004-\u0001\u0003c_>$\u0018\u0002BBA\u0007g\u0012QcQ8oI&$\u0018n\u001c8bY>s\u0007K]8qKJ$\u00180\u0001\u0003oC6,GFABDC\t\u0019I)\u0001\u0013eKBdw.\u001f\u0018tKJ4XM\u001d\u0018tK\u000e,(/\u001b;z]\u0005,H\u000f\u001b\u0018qe>4\u0018\u000eZ3s\u0003-A\u0017M^5oOZ\u000bG.^3\"\u0003MB3aCBI!\u0011\u0019\u0019j!)\u000e\u0005\rU%\u0002BBL\u00073\u000bQbY8oM&<WO]1uS>t'\u0002BAQ\u00077SA!!\r\u0004\u001e*\u00191q\u00140\u0002\r\r|gNZ5h\u0013\u0011\u0019\u0019k!&\u0003#\u0015s\u0017M\u00197f/\u0016\u00147+Z2ve&$\u0018\u0010K\u0002\f\u0007O\u0003B!!\f\u0004*&!11VA\u0018\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\":1ba,\u00046\u000e]\u0006\u0003BA\u0017\u0007cKAaa-\u00020\ti1i\\7q_:,g\u000e^*dC:\fQA^1mk\u0016d#a!/\"\u0005\rm\u0016aJ2p[:BXMY5bY\u0006\u00147O\f=mI\u0016\u0004Hn\\=/CV$\bNL8jI\u000et3m\u001c8gS\u001e\u0004")
public class OpenIdConnectConfig
implements Logging {
    private final Function1<ClientRegistration, JWK> jwkResolver;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static Map<JwsAlgorithm, JWSAlgorithm> RSA_ALGORITHM_MAP() {
        return OpenIdConnectConfig$.MODULE$.RSA_ALGORITHM_MAP();
    }

    public static Map<JwsAlgorithm, JWSAlgorithm> ESA_ALGORITHM_MAP() {
        return OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_MAP();
    }

    public static Map<JwsAlgorithm, Curve> ESA_ALGORITHM_CURVE_MAPPING() {
        return OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_CURVE_MAPPING();
    }

    public static Map<MacAlgorithm, String> MAC_ALGORITHM_MAPPING() {
        return OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        OpenIdConnectConfig openIdConnectConfig = this;
        synchronized (openIdConnectConfig) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigLoader$.MODULE$.loadWithDynamic(ConfigurationHolder$.MODULE$.get(), ConfigLoader$.MODULE$.loadWithDynamic$default$2()), ServerConfiguration.getInstance());
    }

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), "." + this.oidcConfig().external_login(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    public InMemoryClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    public CustomAuthorizationRequestResolver customAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        return new CustomAuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization", this.oidcConfig().additionalParameters());
    }

    @Bean
    public InMemoryOAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    public XLOidcUserService xlOidcUserService(ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        return new XLOidcUserService(claimsToGrantedAuthoritiesPolicy);
    }

    @Bean
    public AuthenticatedPrincipalOAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().idTokenJWSAlg(), "deploy.security.auth.providers.oidc.idTokenJWSAlg");
        CustomOidcIdTokenDecoderFactory idTokenDecoderFactory = new CustomOidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(x$1 -> jwsAlgorithm);
        idTokenDecoderFactory.setRestOperations((RestOperations)restTemplate);
        return idTokenDecoderFactory;
    }

    @Bean
    public JwtDecoder jwtDecoder() {
        NimbusJwtDecoder nimbusJwtDecoder;
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().accessTokenJWSAlg(), "deploy.security.auth.providers.oidc.access-token.jwsAlg");
        JwsAlgorithm jwsAlgorithm2 = jwsAlgorithm;
        if (jwsAlgorithm2 instanceof SignatureAlgorithm) {
            SignatureAlgorithm signatureAlgorithm = (SignatureAlgorithm)jwsAlgorithm2;
            String jwkSetUri = Strings.isNotBlank((String)this.oidcConfig().accessTokenKeyUri()) ? this.oidcConfig().accessTokenKeyUri() : this.clientRegistration().getProviderDetails().getJwkSetUri();
            nimbusJwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(signatureAlgorithm).build();
        } else if (jwsAlgorithm2 instanceof MacAlgorithm) {
            MacAlgorithm macAlgorithm = (MacAlgorithm)jwsAlgorithm2;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenSecretKey()), (String)"No configuration setting found for key 'deploy.security.auth.providers.oidc.access-token.secretKey'", (Object[])new Object[0]);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.oidcConfig().accessTokenSecretKey().getBytes(StandardCharsets.UTF_8), (String)OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING().getOrElse((Object)macAlgorithm, (Function0 & Serializable)() -> {
                throw new IllegalArgumentException("'" + macAlgorithm.getName() + "' is not supported. Ensure you have configured a valid HMAC Algorithm.");
            }));
            nimbusJwtDecoder = NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm(macAlgorithm).build();
        } else {
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        NimbusJwtDecoder jwtDecoder = nimbusJwtDecoder;
        jwtDecoder.setJwtValidator(this.getJwtOAuth2TokenValidator());
        return jwtDecoder;
    }

    @Bean
    public JwtAuthenticationConverter jwtAuthenticationConverter() {
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setPrincipalClaimName(this.oidcConfig().userNameClaimName());
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new GrantedAuthoritiesExtractor((ClaimsToGrantedAuthoritiesPolicy)this.claimsToGrantedAuthoritiesPolicy()));
        return jwtAuthenticationConverter;
    }

    @Bean
    public DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient(ClientRegistrationRepository clientRegistrationRepository) {
        DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient;
        block1: {
            ClientRegistration clientRegistration;
            block0: {
                ListBuffer messageConverter = new ListBuffer();
                messageConverter.$plus$eq((Object)new FormHttpMessageConverter());
                messageConverter.$plus$eq((Object)new OAuth2AccessTokenResponseHttpMessageConverter());
                RestTemplate restTemplate = new RestTemplate(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)messageConverter.toList()).asJava());
                restTemplate.setRequestFactory(this.clientHttpRequestFactory());
                restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
                authorizationCodeTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
                authorizationCodeTokenResponseClient.setRestOperations((RestOperations)restTemplate);
                clientRegistration = clientRegistrationRepository.findByRegistrationId(this.oidcConfig().registrationId());
                ClientAuthenticationMethod clientAuthenticationMethod = clientRegistration.getClientAuthenticationMethod();
                ClientAuthenticationMethod clientAuthenticationMethod2 = ClientAuthenticationMethod.CLIENT_SECRET_JWT;
                if (!(clientAuthenticationMethod == null ? clientAuthenticationMethod2 != null : !clientAuthenticationMethod.equals(clientAuthenticationMethod2))) break block0;
                ClientAuthenticationMethod clientAuthenticationMethod3 = clientRegistration.getClientAuthenticationMethod();
                ClientAuthenticationMethod clientAuthenticationMethod4 = ClientAuthenticationMethod.PRIVATE_KEY_JWT;
                if (clientAuthenticationMethod3 != null ? !clientAuthenticationMethod3.equals(clientAuthenticationMethod4) : clientAuthenticationMethod4 != null) break block1;
            }
            this.setJwk(clientRegistration);
            OAuth2AuthorizationCodeGrantRequestEntityConverter requestEntityConverter = new OAuth2AuthorizationCodeGrantRequestEntityConverter();
            requestEntityConverter.addParametersConverter((Converter)new NimbusJwtClientAuthenticationParametersConverter(FunctionWrappers.RichFunction1AsFunction$.MODULE$.asJavaFunction$extension(FunctionConverters$.MODULE$.enrichAsJavaFunction(this.jwkResolver()))));
            authorizationCodeTokenResponseClient.setRequestEntityConverter((Converter)requestEntityConverter);
        }
        return authorizationCodeTokenResponseClient;
    }

    public Function1<ClientRegistration, JWK> jwkResolver() {
        return this.jwkResolver;
    }

    @Bean
    public AuthenticationFailureHandler oidcLoginFailureHandler() {
        return (request, response, exception) -> {
            this.logger().debug((Function0 & Serializable)() -> "xld:auth: oidcLoginFailureHandler called - request URI: " + request.getRequestURI() + ", context path: " + request.getContextPath() + ", exception type: " + exception.getClass().getSimpleName());
            AuthenticationException authenticationException = exception;
            if (authenticationException instanceof BadCredentialsException ? true : authenticationException instanceof DisabledException) {
                String redirectUrl = request.getContextPath() + "/login?error=" + authenticationException.getMessage();
                this.logger().debug((Function0 & Serializable)() -> "xld:auth: BadCredentialsException or DisabledException - redirecting to: " + redirectUrl);
                response.sendRedirect(redirectUrl);
            } else if (authenticationException instanceof SessionAuthenticationException) {
                SessionAuthenticationException sessionAuthenticationException = (SessionAuthenticationException)authenticationException;
                String redirectUrl = request.getContextPath() + "/login?error=" + sessionAuthenticationException.getMessage();
                this.logger().debug((Function0 & Serializable)() -> "xld:auth: SessionAuthenticationException - redirecting to: " + redirectUrl);
                response.sendRedirect(redirectUrl);
            } else {
                boolean isAjax;
                String externalRedirect = request.getContextPath() + this.oidcConfig().external_login();
                this.logger().debug((Function0 & Serializable)() -> "xld:auth: Other authentication exception (" + exception.getClass().getSimpleName() + ") - redirecting to external login: " + externalRedirect);
                String accept = (String)Option$.MODULE$.apply((Object)request.getHeader("Accept")).getOrElse((Function0 & Serializable)() -> "");
                String xRequestedWith = (String)Option$.MODULE$.apply((Object)request.getHeader("X-Requested-With")).getOrElse((Function0 & Serializable)() -> "");
                boolean bl = isAjax = xRequestedWith.equalsIgnoreCase("XMLHttpRequest") || accept.contains("application/json");
                if (isAjax) {
                    String encoded = URLEncoder.encode((String)Option$.MODULE$.apply((Object)exception.getMessage()).getOrElse((Function0 & Serializable)() -> ""), StandardCharsets.UTF_8.name());
                    String spaHashRedirect = request.getContextPath() + "/#/login?error=" + encoded;
                    this.logger().debug((Function0 & Serializable)() -> "xld:auth: AJAX request detected - redirecting to SPA hash login: " + spaHashRedirect);
                    response.sendRedirect(spaHashRedirect);
                } else {
                    response.sendRedirect(externalRedirect);
                }
            }
            this.logger().debug((Function0 & Serializable)() -> "xld:auth: oidcLoginFailureHandler completed");
        };
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler xldLoginFailureHandler() {
        return new SimpleUrlAuthenticationFailureHandler();
    }

    @Bean
    public OidcLogoutSuccessHandler openIdLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        return new OidcLogoutSuccessHandler(clientRegistrationRepository, this.oidcConfig().postLogoutRedirectUri(), "login");
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    @Bean
    public OidcUserProfileCreationPolicy oidcUserProfileCreationPolicy() {
        return new OidcUserProfileCreationPolicy(this.oidcConfig().emailClaim(), this.oidcConfig().fullNameClaim());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private ClientRegistration clientRegistration() {
        clientRegistrationBuilder = this.getClientRegistrationBuilder();
        authenticationMethod = this.getClientAuthMethod();
        clientRegistrationBuilder.clientId(this.oidcConfig().clientId()).clientAuthenticationMethod(authenticationMethod).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri(this.oidcConfig().redirectUri()).userInfoUri("").scope(this.oidcConfig().scopes()).userNameAttributeName(this.oidcConfig().userNameClaimName());
        v0 = authenticationMethod;
        var3_3 = ClientAuthenticationMethod.NONE;
        if (!(v0 == null ? var3_3 != null : v0.equals(var3_3) == false)) ** GOTO lbl-1000
        v1 = authenticationMethod;
        var4_4 = ClientAuthenticationMethod.PRIVATE_KEY_JWT;
        if (v1 == null ? var4_4 != null : v1.equals(var4_4) == false) {
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().clientSecret()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientSecret"), (Object[])new Object[0]);
            v2 = clientRegistrationBuilder.clientSecret(this.oidcConfig().clientSecret());
        } else lbl-1000:
        // 2 sources

        {
            v2 = BoxedUnit.UNIT;
        }
        v3 = authenticationMethod;
        var5_5 = ClientAuthenticationMethod.PRIVATE_KEY_JWT;
        if (!(v3 != null ? v3.equals(var5_5) == false : var5_5 != null)) {
            if (Strings.isBlank((String)this.oidcConfig().keyStorePath())) {
                this.oidcConfig().keyStorePath_$eq(this.oidcConfig().defaultKeyStorePath());
                this.oidcConfig().keyStorePassword_$eq(this.oidcConfig().defaultKeyStorePassword());
            }
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().keyStorePath()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.path"), (Object[])new Object[0]);
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().keyAlias()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientAuthJwt.key.alias"), (Object[])new Object[0]);
        }
        v4 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()) != false ? clientRegistrationBuilder.authorizationUri(this.oidcConfig().userAuthorizationUri()) : BoxedUnit.UNIT;
        v5 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()) != false ? clientRegistrationBuilder.tokenUri(this.oidcConfig().accessTokenUri()) : BoxedUnit.UNIT;
        v6 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().jwks_uri()) != false ? clientRegistrationBuilder.jwkSetUri(this.oidcConfig().jwks_uri()) : BoxedUnit.UNIT;
        clientRegistration = clientRegistrationBuilder.build();
        configurationMetadata = clientRegistration.getProviderDetails().getConfigurationMetadata();
        updatedConfigurationMetadata = new HashMap<String, String>(configurationMetadata);
        updatedConfigurationMetadata.put("rolesClaim", this.oidcConfig().rolesClaimName());
        v7 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().logoutUri()) != false ? updatedConfigurationMetadata.put("end_session_endpoint", this.oidcConfig().logoutUri()) : BoxedUnit.UNIT;
        return ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).providerConfigurationMetadata(updatedConfigurationMetadata).build();
    }

    private ClientRegistration.Builder getClientRegistrationBuilder() {
        ClientRegistration.Builder builder;
        try {
            if (!this.oidcConfig().issuer().matches("\\S+")) {
                throw new UnsupportedOidcConfigurationException("Whitespace characters in issuer url [" + this.oidcConfig().issuer() + "] is not supported. Recommendation is to avoid using spaces in URLs, and instead use hyphens to separate words.");
            }
            builder = ClientRegistrations.fromOidcIssuerLocation((String)this.oidcConfig().issuer()).registrationId(this.oidcConfig().registrationId());
        }
        catch (RuntimeException re) {
            RuntimeException runtimeException = re;
            if (runtimeException instanceof IllegalArgumentException) {
                this.logger().warn((Function0 & Serializable)() -> "Unable to resolve Configuration with the provided Issuer of [" + this.oidcConfig().issuer() + "]");
            } else if (runtimeException instanceof UnsupportedOidcConfigurationException) {
                this.logger().warn((Function0 & Serializable)() -> re.getMessage());
            } else {
                throw new MatchError((Object)runtimeException);
            }
            this.validateOidcConfiguration();
            builder = ClientRegistration.withRegistrationId((String)this.oidcConfig().registrationId());
        }
        return builder;
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory requestFactory;
        block0: {
            requestFactory = new SimpleClientHttpRequestFactory();
            if (!Strings.isNotBlank((String)this.oidcConfig().proxyHost())) break block0;
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.oidcConfig().proxyHost(), Predef$.MODULE$.Integer2int(this.oidcConfig().proxyPort()))));
        }
        return requestFactory;
    }

    private JwsAlgorithm getJwsAlgorithm(String jwsAlgorithm, String propertyName) {
        Map jwsAlgorithms = (Map)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SignatureAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return (JwsAlgorithm)jwsAlgorithms.getOrElse((Object)jwsAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(propertyName + " value [" + jwsAlgorithm + "] is not supported. Ensure you have configured a valid JWS Algorithm.");
        });
    }

    private MacAlgorithm getMacAlgorithm(String macAlgorithm, String propertyName) {
        Map macAlgorithms = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (MacAlgorithm)macAlgorithms.getOrElse((Object)macAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(propertyName + " value [" + macAlgorithm + "] is not supported. Ensure you have configured a valid HMAC Algorithm.");
        });
    }

    private SignatureAlgorithm getSignatureAlgorithm(String signatureAlgorithm, String propertyName) {
        Map signatureAlgorithms = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SignatureAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (SignatureAlgorithm)signatureAlgorithms.getOrElse((Object)signatureAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(propertyName + " value [" + signatureAlgorithm + "] is not supported. Ensure you have configured a valid Signature Algorithm.");
        });
    }

    private ClientAuthenticationMethod getClientAuthMethod() {
        Map clientAuthMethods = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_basic"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_post"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_POST), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_jwt"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"private_key_jwt"), (Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"none"), (Object)ClientAuthenticationMethod.NONE)}));
        return (ClientAuthenticationMethod)clientAuthMethods.getOrElse((Object)this.oidcConfig().clientAuthMethod().toLowerCase(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("clientAuthMethod value [" + this.oidcConfig().clientAuthMethod() + " is not supported. Ensure you have configured a valid client authentication method.]");
        });
    }

    private OAuth2TokenValidator<Jwt> getJwtOAuth2TokenValidator() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(Strings.isNotBlank((String)this.oidcConfig().accessTokenIssuer()) ? this.oidcConfig().accessTokenIssuer() : this.oidcConfig().issuer()));
        validators.add(new JwtClaimValidator("aud", aud -> aud.contains(Strings.isNotBlank((String)this.oidcConfig().accessTokenAudience()) ? this.oidcConfig().accessTokenAudience() : this.oidcConfig().clientId())));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private void validateOidcConfiguration() {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.userAuthorizationUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.accessTokenUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().jwks_uri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.keyRetrievalUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().logoutUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.logoutUri"), (Object[])new Object[0]);
    }

    private String getErrorMessageForPlaceholder(String placeholder) {
        return "No configuration setting found for key '" + placeholder + "'";
    }

    private void setJwk(ClientRegistration clientRegistration) {
        if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT)) {
            MacAlgorithm jwsAlgorithm = this.getMacAlgorithm(this.oidcConfig().clientAuthJWSAlg(), "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg");
            MacAlgorithm macAlgorithm = jwsAlgorithm;
            if (macAlgorithm != null) {
                MacAlgorithm macAlgorithm2 = macAlgorithm;
                SecretKeySpec secretKey = new SecretKeySpec(clientRegistration.getClientSecret().getBytes(StandardCharsets.UTF_8), (String)OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING().getOrElse((Object)macAlgorithm2, (Function0 & Serializable)() -> {
                    throw new IllegalArgumentException("'" + macAlgorithm2.getName() + "' is not supported. Ensure you have configured a valid HMAC Algorithm.");
                }));
                this.oidcConfig().jwk_$eq((JWK)new OctetSequenceKey.Builder((SecretKey)secretKey).algorithm(new Algorithm(macAlgorithm2.getName())).keyUse(KeyUse.SIGNATURE).keyID(UUID.randomUUID().toString()).build());
                return;
            }
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
            SignatureAlgorithm jwsAlgorithm = this.getSignatureAlgorithm(this.oidcConfig().clientAuthJWSAlg(), "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg");
            SignatureAlgorithm signatureAlgorithm = jwsAlgorithm;
            if (signatureAlgorithm != null) {
                KeyPair keyPair = this.getKeyPair();
                if (OpenIdConnectConfig$.MODULE$.RSA_ALGORITHM_MAP().contains((Object)jwsAlgorithm)) {
                    this.oidcConfig().jwk_$eq((JWK)this.getRSAKey(keyPair, (Algorithm)OpenIdConnectConfig$.MODULE$.RSA_ALGORITHM_MAP().apply((Object)jwsAlgorithm)));
                    return;
                }
                if (OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_MAP().contains((Object)jwsAlgorithm)) {
                    this.oidcConfig().jwk_$eq((JWK)this.getESAKey(keyPair, (Algorithm)OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_MAP().apply((Object)jwsAlgorithm), (Curve)OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_CURVE_MAPPING().apply((Object)jwsAlgorithm)));
                    return;
                }
                throw new UnsupportedOidcConfigurationException("Ensure you have configured a valid JWS Algorithm.");
            }
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        this.oidcConfig().jwk_$eq(null);
    }

    private KeyPair getKeyPair() {
        Try tryKeyPair;
        Try try_;
        File file = new File(this.oidcConfig().keyStorePath());
        if (!file.exists()) {
            throw new IllegalArgumentException("Cannot find keystore [" + this.oidcConfig().keyStorePath() + "]");
        }
        if (Strings.isBlank((String)this.oidcConfig().keyStorePassword())) {
            this.logger().warn((Function0 & Serializable)() -> "The keystore [" + this.oidcConfig().keyStorePath() + "] is not protected by a password. It is recommended to secure it using a password.");
        }
        if ((try_ = (tryKeyPair = Using$.MODULE$.apply((Function0 & Serializable)() -> new FileInputStream(file), (Function1 & Serializable)in -> {
            String kst = Strings.isNotBlank((String)this.oidcConfig().keyStoreType()) ? this.oidcConfig().keyStoreType() : KeyStore.getDefaultType();
            KeyStore keystore = KeyStore.getInstance(kst);
            char[] ksp = Strings.isNotBlank((String)this.oidcConfig().keyStorePassword()) ? this.oidcConfig().keyStorePassword().toCharArray() : null;
            keystore.load((InputStream)in, ksp);
            char[] kp = Strings.isNotBlank((String)this.oidcConfig().keyPassword()) ? this.oidcConfig().keyPassword().toCharArray() : null;
            PrivateKey privateKey = (PrivateKey)keystore.getKey(this.oidcConfig().keyAlias(), kp);
            Certificate cert = keystore.getCertificate(this.oidcConfig().keyAlias());
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, privateKey);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$))) instanceof Success) {
            Success success = (Success)try_;
            KeyPair value = (KeyPair)success.value();
            return value;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw new DeployitException(exception);
        }
        throw new MatchError((Object)try_);
    }

    private RSAKey getRSAKey(KeyPair keyPair, Algorithm algorithm) {
        RSAKey.Builder builder = new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey(keyPair.getPrivate()).algorithm(algorithm).keyUse(KeyUse.SIGNATURE);
        if (Strings.isNotBlank((String)this.oidcConfig().tokenKeyId())) {
            v0 = builder.keyID(this.oidcConfig().tokenKeyId());
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Building RSAKey without token k-id. Token key Id not provided in configuration.");
            v0 = BoxedUnit.UNIT;
        }
        return builder.build();
    }

    private ECKey getESAKey(KeyPair keyPair, Algorithm algorithm, Curve curve) {
        ECKey.Builder builder = new ECKey.Builder(curve, (ECPublicKey)keyPair.getPublic()).privateKey((ECPrivateKey)keyPair.getPrivate()).algorithm(algorithm).keyUse(KeyUse.SIGNATURE);
        if (Strings.isNotBlank((String)this.oidcConfig().tokenKeyId())) {
            v0 = builder.keyID(this.oidcConfig().tokenKeyId());
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Building ECKey without token k-id. Token key Id not provided in configuration.");
            v0 = BoxedUnit.UNIT;
        }
        return builder.build();
    }

    public OpenIdConnectConfig() {
        Logging.$init$((Logging)this);
        this.jwkResolver = (Function1 & Serializable)clientRegistration -> {
            if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT) || clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
                return this.oidcConfig().jwk();
            }
            return null;
        };
    }
}

