/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */

package com.xebialabs.deployit.core.rest.view;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The invocation description object containing document input/output and diff for given
 * invocation with list of called processors and possible errors.
 */
@PublicApiRef
public class InvocationDescriptorView extends AbstractDto implements BasePreview {

  private String input;
  private String output;
  private String diff;
  private List<InvocationProcessorView> processors = new ArrayList<>();
  private Map<String, String> errors = new HashMap<>();

  public InvocationDescriptorView() {
  }

  public InvocationDescriptorView(String input,
                                  String output,
                                  String diff,
                                  List<InvocationProcessorView> processors,
                                  Map<String, String> errors) {
    this.input = input;
    this.output = output;
    this.diff = diff;
    this.processors = processors;
    this.errors = errors;
  }

  /**
   * Returns input object as string.
   *
   * @return The input document for transformation.
   */
  public String getInput() {
    return input;
  }

  /**
   * Sets input object as string.
   *
   * @param input The input document for transformation.
   */
  public void setInput(String input) {
    this.input = input;
  }

  /**
   * Returns output object as string.
   *
   * @return The output document from transformation.
   */
  public String getOutput() {
    return output;
  }

  /**
   * Sets output object as string.
   *
   * @param output The output document from transformation.
   */
  public void setOutput(String output) {
    this.output = output;
  }

  /**
   * Returns diff object as string.
   *
   * @return The diff for input and output adopted for text preview.
   */
  public String getDiff() {
    return diff;
  }

  /**
   * Sets diff object as string.
   *
   * @param diff The diff for input and output adopted for text preview.
   */
  public void setDiff(String diff) {
    this.diff = diff;
  }

  /**
   * Returns list of processor details that were used in invocation
   * transformations in order of execution.
   *
   * @return List of processors.
   */
  public List<InvocationProcessorView> getProcessors() {
    return processors;
  }

  /**
   * Sets list of processor details that were used in invocation transformations
   * in order of execution.
   *
   * @param processors List of processors.
   */
  public void setProcessors(List<InvocationProcessorView> processors) {
    this.processors = processors;
  }

  /**
   * Returns map of errors per processor.
   *
   * @return Map of errors with processor ID as key to indicate errors that happened during invocation.
   *              This list is empty if no errors occurred.
   */
  public Map<String, String> getErrors() {
    return errors;
  }

  /**
   * Sets map of errors per processor.
   *
   * @param errors Map of errors with processor ID as key to indicate errors that happened during invocation.
   *              This list is empty if no errors occurred.
   */
  public void setErrors(Map<String, String> errors) {
    this.errors = errors;
  }
}
