/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.expression.resolver;

import com.xebialabs.deployit.plugin.stitch.service.engine.context.DeploymentContext;
import com.xebialabs.deployit.plugin.stitch.service.engine.context.InputContext;
import com.xebialabs.xlplatform.documentation.PublicApi;

/**
 * Abstract class used in conjunction with ExpressionUtility to create expressions utility bean.
 * @see com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.expression.annotation.ExpressionUtility
 * @see com.xebialabs.deployit.plugin.stitch.service.engine.context.DeploymentContext
 * @see com.xebialabs.deployit.plugin.stitch.service.engine.context.InputContext
 */
@PublicApi
public abstract class AbstractContextResolver {
    private DeploymentContext deploymentContext;
    private InputContext inputContext;

    /**
     * Creates context resolver.
     * @param deploymentContext stitch deployment context
     * @param inputContext stitch input context
     */
    public AbstractContextResolver(final DeploymentContext deploymentContext, final InputContext inputContext) {
        this.deploymentContext = deploymentContext;
        this.inputContext = inputContext;
    }

    /**
     * Returns deployment context.
     * @return deployment context.
     * @see com.xebialabs.deployit.plugin.stitch.service.engine.context.DeploymentContext
     */
    public DeploymentContext getDeploymentContext() {
        return deploymentContext;
    }

    /**
     * Returns input context.
     * @return input context.
     * @see com.xebialabs.deployit.plugin.stitch.service.engine.context.InputContext
     */
    public InputContext getInputContext() {
        return inputContext;
    }
}
