/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */

package com.xebialabs.deployit.core.rest.view;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.UUID;

/**
 * The details about the processor called for stitch transformation.
 */
@PublicApiRef
public class InvocationProcessorView extends AbstractDto {

  private UUID id;
  private String type;
  private String description;
  private String namespace;
  private UUID namespaceId;
  private Integer phase;
  private String ruleName;
  private UUID ruleId;
  private Integer weight;
  private String mergeType;

  public InvocationProcessorView(UUID id,
                                 String type,
                                 String description,
                                 String namespace,
                                 UUID namespaceId,
                                 Integer phase,
                                 String ruleName,
                                 UUID ruleId,
                                 Integer weight,
                                 String mergeType) {
    this.id = id;
    this.type = type;
    this.description = description;
    this.namespace = namespace;
    this.namespaceId = namespaceId;
    this.phase = phase;
    this.ruleName = ruleName;
    this.ruleId = ruleId;
    this.weight = weight;
    this.mergeType = mergeType;
  }

  public InvocationProcessorView() {
  }

  /**
   * Returns processor ID.
   *
   * @return The ID of processor.
   */
  public UUID getId() {
    return id;
  }

  /**
   * Sets processor ID.
   *
   * @param id The processor ID.
   */
  public void setId(UUID id) {
    this.id = id;
  }

  /**
   * Returns processor type.
   *
   * @return The type of processor.
   */
  public String getType() {
    return type;
  }

  /**
   * Sets processor type.
   *
   * @param type The processor type.
   */
  public void setType(String type) {
    this.type = type;
  }
  /**
   * Returns processor description.
   *
   * @return The description of processor.
   */

  public String getDescription() {
    return description;
  }

  /**
   * Sets processor description.
   *
   * @param description The processor description.
   */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Return processor namespace.
   *
   * @return The namespace of rule for processor.
   */
  public String getNamespace() {
    return namespace;
  }

  /**
   * Sets processor's rule namespace.
   *
   * @param namespace The processor's rule namespace.
   */
  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }

  /**
   * Returns processor's rule namespace ID.
   *
   * @return The namespace ID of rule for processor.
   */
  public UUID getNamespaceId() {
    return namespaceId;
  }

  /**
   * Sets processor's rule namespace ID.
   *
   * @param namespaceId The processor's rule namespace ID.
   */
  public void setNamespaceId(UUID namespaceId) {
    this.namespaceId = namespaceId;
  }

  /**
   * Returns processor's phase.
   *
   * @return The phase indicator of processor.
   */
  public Integer getPhase() {
    return phase;
  }

  /**
   * Sets processor's phase.
   *
   * @param phase The processor phase.
   */
  public void setPhase(Integer phase) {
    this.phase = phase;
  }

  /**
   * Returns processor's rule name.
   *
   * @return The rule name for the processor.
   */
  public String getRuleName() {
    return ruleName;
  }

  /**
   * Sets processor's rule name.
   *
   * @param ruleName The processor rule name.
   */
  public void setRuleName(String ruleName) {
    this.ruleName = ruleName;
  }

  /**
   * Returns processor's rule ID.
   *
   * @return The rule ID for the processor.
   */
  public UUID getRuleId() {
    return ruleId;
  }

  /**
   * Sets processor's rule ID.
   *
   * @param ruleId The processor rule ID.
   */
  public void setRuleId(UUID ruleId) {
    this.ruleId = ruleId;
  }

  /**
   * Returns processor's weight.
   *
   * @return The weight of processor.
   */
  public Integer getWeight() {
    return weight;
  }

  /**
   * Sets processor's weight.
   *
   * @param weight The processor weight.
   */
  public void setWeight(Integer weight) {
    this.weight = weight;
  }

  /**
   * Returns processor's mergeType.
   *
   * @return The mergeType of processor.
   */
  public String getMergeType() {
    return mergeType;
  }

  /**
   * Sets processor's mergeType.
   *
   * @param mergeType The processor merge type.
   */
  public void setMergeType(String mergeType) {
    this.mergeType = mergeType;
  }
}
