/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */

package com.xebialabs.deployit.plugin.stitch.service.engine.format.output.consumer;

import com.fasterxml.jackson.databind.JsonNode;
import com.xebialabs.xlplatform.documentation.PublicApi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;

/**
 * Output consumer responsible for transforming {@link JsonNode} to desired output format.
 */
@PublicApi
public interface OutputConsumer {
  /**
   * Gets all file formats that are supported with this consumer.
   *
   * @return set of file formats
   */
  Set<String> getFileFormats();

  /**
   * Writes result of transformation of {@link JsonNode} to {@link OutputStream}.
   *
   * @param node   node to be transformed
   * @param output output where transformed node should be written to
   * @throws IOException when transforming node to output
   */
  void write(JsonNode node, OutputStream output) throws IOException;
}
