/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */

package com.xebialabs.deployit.core.rest.view;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * The flag object if we run stitch transformation for given deployment.
 */
@PublicApiRef
public class StitchEvaluationView extends AbstractDto {

  private boolean show;

  public StitchEvaluationView() {
  }

  public StitchEvaluationView(boolean show) {
    this.show = show;
  }

  /**
   * Returns a flag if stitch was executed.
   *
   * @return The show flag if stitch was executed during deployment preview.
   */
  public boolean isShow() {
    return show;
  }

  /**
   * Sets a flag if stitch was executed.
   *
   * @param show The show flag if stitch was executed during deployment preview.
   */
  public void setShow(boolean show) {
    this.show = show;
  }
}
