/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine.index.dto;

import com.xebialabs.xlplatform.documentation.PublicApi;

import java.util.List;

/**
 * Represent processor during parsing and validation phase.
 */
@PublicApi
public interface StitchProcessorDto {

  /**
   * Returns processors parameters.
   * @return processors parameters as list of {@link StitchProcessorParameterDto}.
   */
  List<? extends StitchProcessorParameterDto> getProcessorParameters();

  /**
   * Returns processors description.
   * @return processors description.
   */
  String describeAsString();
}
