<#--

    Copyright (c) 2018. All rights reserved.

    This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

-->
<#assign envVars=container.envVars />
<#list envVars?keys as envVar>
${envVar}="${envVars[envVar]}"
export ${envVar}
</#list>
status=UNKNOWN
cd "${container.home}"

check_status() {
    if [ $? -eq 0 ] && [ "$pid" -gt 0 ] ; then
        status=RUNNING
    elif [ $? -eq 0 ] ; then
        echo "Check the status command"
        exit 1
    else
        status=STOPPED
    fi
    echo "Server is currently $status"
}

echo 'Checking server status...'
<#if container.statusCommand??>
    ${container.statusCommand}
<#else>
    pid=$(lsof -t -i :${container.tomcatRunningPort} -s)
</#if>
check_status
