/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.processor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextElement;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final Type CONTEXT_ELEMENT_TYPE = Type.valueOf(ContextElement.class);
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static Iterable<AbstractDeployed<?>> findDeployedsTargetedToContainer(List<Delta> deltas, Type containerType) {
        Iterable destroyNoopCreateDeltasTargetedToContainer = Iterables.filter(deltas, (Predicate)DeltasTargetedToContainerFilter.filterAllOperationsBesidesModifyOps(containerType));
        Iterable modifyDestroyDeltasTargetedToContainer = Iterables.filter(deltas, (Predicate)DeltasTargetedToContainerFilter.filterOnlyModifyOpsAndPreviousDeployed(containerType));
        Iterable modifyCreateDeltasTargetedToContainer = Iterables.filter(deltas, (Predicate)DeltasTargetedToContainerFilter.filterOnlyModifyOpsAndCurrentDeployed(containerType));
        Iterable destroyNoopAndCreateDeployeds = Iterables.transform((Iterable)destroyNoopCreateDeltasTargetedToContainer, (Function)new DeltaToAbstractDeployedTransformer());
        Iterable destroyDeployedsFromModifyDeltas = Iterables.transform((Iterable)modifyDestroyDeltasTargetedToContainer, (Function)new DeltaToAbstractDeployedTransformer(true));
        Iterable createDeployedsFromModifyDeltas = Iterables.transform((Iterable)modifyCreateDeltasTargetedToContainer, (Function)new DeltaToAbstractDeployedTransformer());
        return Iterables.concat((Iterable)destroyNoopAndCreateDeployeds, (Iterable)destroyDeployedsFromModifyDeltas, (Iterable)createDeployedsFromModifyDeltas);
    }

    public static boolean isSubtypeOf(Type supertype, Type subtype) {
        Collection typeAndSubtypes = DescriptorRegistry.getSubtypes((Type)supertype);
        boolean contains = supertype.equals((Object)subtype) || typeAndSubtypes.contains(subtype);
        logger.trace("Check {} is a subtype of {} is {} ", new Object[]{subtype, supertype, contains});
        return contains;
    }

    public static Iterable<ContextElement<?>> extractDeployedContextElements(Iterable<AbstractDeployed<?>> abstractDeployeds) {
        return Iterables.transform((Iterable)Iterables.filter(abstractDeployeds, (Predicate)new Predicate<AbstractDeployed<?>>(){

            public boolean apply(AbstractDeployed<?> input) {
                return Utils.isSubtypeOf(CONTEXT_ELEMENT_TYPE, input.getType());
            }
        }), (Function)new Function<AbstractDeployed<?>, ContextElement<?>>(){

            public ContextElement<?> apply(AbstractDeployed<?> input) {
                return (ContextElement)input;
            }
        });
    }

    private static class DeltaToAbstractDeployedTransformer
    implements Function<Delta, AbstractDeployed<?>> {
        private boolean transformPreviousDeployedForModifyOp;

        DeltaToAbstractDeployedTransformer() {
        }

        DeltaToAbstractDeployedTransformer(boolean transformPreviousDeployedForModifyOp) {
            this.transformPreviousDeployedForModifyOp = transformPreviousDeployedForModifyOp;
        }

        public AbstractDeployed<?> apply(Delta input) {
            Deployed deployed = input.getDeployed();
            if (input.getOperation() == Operation.MODIFY) {
                if (this.transformPreviousDeployedForModifyOp) {
                    deployed = input.getPrevious();
                }
            } else if (input.getOperation() == Operation.DESTROY) {
                deployed = input.getPrevious();
            }
            return (AbstractDeployed)deployed;
        }
    }

    private static class DeltasTargetedToContainerFilter
    implements Predicate<Delta> {
        private Type type;
        private boolean modifyOpsMode;
        private boolean filterPreviousDeployed;

        DeltasTargetedToContainerFilter(Type type) {
            this.type = type;
        }

        DeltasTargetedToContainerFilter(Type type, boolean modifyOpsMode, boolean filterPreviousDeployed) {
            this.type = type;
            this.modifyOpsMode = modifyOpsMode;
            this.filterPreviousDeployed = filterPreviousDeployed;
        }

        static DeltasTargetedToContainerFilter filterAllOperationsBesidesModifyOps(Type type) {
            return new DeltasTargetedToContainerFilter(type);
        }

        static DeltasTargetedToContainerFilter filterOnlyModifyOpsAndPreviousDeployed(Type type) {
            return new DeltasTargetedToContainerFilter(type, true, true);
        }

        static DeltasTargetedToContainerFilter filterOnlyModifyOpsAndCurrentDeployed(Type type) {
            return new DeltasTargetedToContainerFilter(type, true, false);
        }

        public boolean apply(Delta input) {
            if (input.getOperation() == Operation.MODIFY) {
                if (!this.modifyOpsMode) {
                    return false;
                }
                Deployed deployed = this.filterPreviousDeployed ? input.getPrevious() : input.getDeployed();
                return DeltasTargetedToContainerFilter.accept(deployed, this.type);
            }
            return DeltasTargetedToContainerFilter.accept(input.getPrevious(), this.type) || DeltasTargetedToContainerFilter.accept(input.getDeployed(), this.type);
        }

        private static boolean accept(Deployed<?, ?> deployed, Type type) {
            return deployed != null && Utils.isSubtypeOf(type, deployed.getContainer().getType()) && deployed instanceof AbstractDeployed;
        }
    }
}

