/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.deployed;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.CopiedArtifact;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.generic.step.TemplateArtifactCopyStep;
import com.xebialabs.deployit.plugin.jee.artifact.War;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.tomcat.step.RenameFileStep;
import java.util.Set;

@Metadata(virtual=true, description="War Module that has an associated context.xml")
public class ContextWarModule
extends CopiedArtifact<War> {
    @Property(description="Context root under which the web application can be access", defaultValue="${deployed.name}")
    private String contextRoot;
    @Property(hidden=true, description="Freemarker template used to create the context xml for the War")
    private String contextTemplate;
    @Property(hidden=true, description="Target directory to which the context xml must to copied to on the target system")
    private String contextXmlTargetDirectory;
    @Property(hidden=true, defaultValue="60", description="The order of the create context step in the step list for the create operation.")
    private int createOrderOfContextXml;
    @Property(hidden=true, defaultValue="60", description="The order of the rename context root step in the step list for the modify operation.")
    private int modifyOrderOfContextXml;
    @Property(hidden=true, defaultValue="40", description="The order of the destroy context step in the step list for the create operation.")
    private int destroyOrderOfContextXml;
    @Property(hidden=true, defaultValue="war settings")
    private String contextSubject;
    @Property(required=false, hidden=true, description="Absolute paths to files on the target system that was generated and must be clean up during a destroy operation")
    private Set<String> deleteGeneratedResources = Sets.newHashSet();
    private boolean destroyOperation;

    public void executeModify(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        ContextWarModule contextWarModule = (ContextWarModule)delta.getPrevious();
        if (!contextWarModule.getContextRoot().equals(this.getContextRoot())) {
            String string = ((HostContainer)this.getContainer()).getHost().getOs().getFileSeparator();
            String string2 = contextWarModule.resolveContextFile(string);
            String string3 = this.resolveContextFile(string);
            String string4 = "Change context from " + contextWarModule.getContextRoot() + " to " + this.getContextRoot() + " on " + ((HostContainer)this.getContainer()).getName();
            deploymentPlanningContext.addStep((DeploymentStep)new RenameFileStep(this.getModifyOrderOfContextXml(), string2, string3, string4, (HostContainer)this.getContainer()));
        }
        deploymentPlanningContext.addStep((DeploymentStep)contextWarModule.createArtifactDeleteStep());
        deploymentPlanningContext.addStep((DeploymentStep)this.createTemplateArtifactCopyStep(this.getModifyOrderOfContextXml(), this.getModifyVerb()));
        deploymentPlanningContext.addStep((DeploymentStep)this.createArtifactCopyStep());
    }

    public void executeCreate(DeploymentPlanningContext deploymentPlanningContext) {
        deploymentPlanningContext.addStep((DeploymentStep)this.createTemplateArtifactCopyStep(this.getCreateOrderOfContextXml(), this.getCreateVerb()));
        deploymentPlanningContext.addStep((DeploymentStep)this.createArtifactCopyStep());
    }

    public void executeDestroy(DeploymentPlanningContext deploymentPlanningContext) {
        this.destroyOperation = true;
        deploymentPlanningContext.addStep((DeploymentStep)this.createTemplateArtifactCopyStep(this.getDestroyOrderOfContextXml(), this.getModifyVerb()));
        deploymentPlanningContext.addStep((DeploymentStep)this.createArtifactDeleteStep());
    }

    protected TemplateArtifactCopyStep createTemplateArtifactCopyStep(int n, String string) {
        TemplateArtifactCopyStep templateArtifactCopyStep = new TemplateArtifactCopyStep(n, (HostContainer)this.getContainer(), this.getDeployedAsFreeMarkerContext(), this.getContextTemplate(), this.getContextXmlTargetDirectory());
        templateArtifactCopyStep.setCreateTargetPath(this.isCreateTargetDirectory());
        templateArtifactCopyStep.setTargetFileName(this.getContextRoot() + ".xml");
        templateArtifactCopyStep.setSourceFileDescription("Context Xml");
        templateArtifactCopyStep.setDescription(this.getContextDescription(string));
        return templateArtifactCopyStep;
    }

    protected ArtifactDeleteStep createArtifactDeleteStep() {
        ArtifactDeleteStep artifactDeleteStep = super.createArtifactDeleteStep();
        artifactDeleteStep.setDeleteAdditionalTargetFiles((Set)Sets.newHashSet((Object[])new String[]{this.getTargetDirectory() + artifactDeleteStep.getHostFileSeparator() + this.getContextRoot()}));
        return artifactDeleteStep;
    }

    public String resolveContextFile(String string) {
        return this.getContextXmlTargetDirectory() + string + this.getContextRoot() + ".xml";
    }

    public String getContextDescription(String string) {
        return String.format("%s %s in %s.xml on %s", string, this.getContextSubject(), this.getContextRoot(), ((HostContainer)this.getContainer()).getName());
    }

    public String getContextRoot() {
        return this.resolveExpression(this.contextRoot);
    }

    public void setContextRoot(String string) {
        this.contextRoot = string;
    }

    public String getContextTemplate() {
        return this.resolveExpression(this.contextTemplate);
    }

    public void setContextTemplate(String string) {
        this.contextTemplate = string;
    }

    public int getCreateOrderOfContextXml() {
        return this.createOrderOfContextXml;
    }

    public void setCreateOrderOfContextXml(int n) {
        this.createOrderOfContextXml = n;
    }

    public String getContextXmlTargetDirectory() {
        return this.resolveExpression(this.contextXmlTargetDirectory);
    }

    public void setContextXmlTargetDirectory(String string) {
        this.contextXmlTargetDirectory = string;
    }

    public Set<String> getDeleteGeneratedResources() {
        return this.resolveExpression(this.deleteGeneratedResources);
    }

    public void setDeleteGeneratedResources(Set<String> set) {
        this.deleteGeneratedResources = set;
    }

    public int getModifyOrderOfContextXml() {
        return this.modifyOrderOfContextXml;
    }

    public void setModifyOrderOfContextXml(int n) {
        this.modifyOrderOfContextXml = n;
    }

    public int getDestroyOrderOfContextXml() {
        return this.destroyOrderOfContextXml;
    }

    public void setDestroyOrderOfContextXml(int n) {
        this.destroyOrderOfContextXml = n;
    }

    public boolean isDestroyOperation() {
        return this.destroyOperation;
    }

    public String getContextSubject() {
        return this.contextSubject;
    }

    public void setContextSubject(String string) {
        this.contextSubject = string;
    }
}

