/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.processor;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextElement;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextWarModule;
import com.xebialabs.deployit.plugin.tomcat.processor.Utils;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationContextNameInjector {
    public static final Type APPLICATION_CONTEXT_TYPE = Type.valueOf((String)"tomcat.VirtualHost");
    private static final Logger logger = LoggerFactory.getLogger(ApplicationContextNameInjector.class);

    @PrePlanProcessor
    public List<DeploymentStep> injectContextNameInToContextElements(DeltaSpecification deltaSpecification) {
        Iterable<ContextElement<?>> iterable = this.findAllContextElementsTargetedToApplicationContexts(deltaSpecification.getDeltas());
        logger.debug("Found {} context elements targeted to application contexts", (Object)Iterables.size(iterable));
        Iterable<Delta> iterable2 = ApplicationContextNameInjector.findContextWarModulesTargetedToVirtualHost(deltaSpecification.getDeltas());
        logger.debug("Found {} warModules targeted to application contexts", (Object)Iterables.size(iterable2));
        this.injectContextNameIntoContextElementsUsingWarResolution(iterable2, iterable);
        this.validateAllContextElementsTargetedToApplicationContextHasCtxNameSet(iterable);
        return Collections.emptyList();
    }

    protected void injectContextNameIntoContextElementsUsingWarResolution(Iterable<Delta> iterable, Iterable<ContextElement<?>> iterable2) {
        if (Iterables.size(iterable) == 1) {
            Delta delta = iterable.iterator().next();
            this.injectContextIntoContextElementsUsingWar(delta, iterable2);
        }
    }

    protected void validateAllContextElementsTargetedToApplicationContextHasCtxNameSet(Iterable<ContextElement<?>> iterable) {
        for (ContextElement<?> contextElement : iterable) {
            Preconditions.checkState((Strings.emptyToNull((String)contextElement.getContext()) != null ? 1 : 0) != 0, (String)"Context for resource %s targeted to %s cannot be determined. Please specify the context.", (Object[])new Object[]{contextElement.getName(), ((HostContainer)contextElement.getContainer()).getName()});
        }
    }

    protected void injectContextIntoContextElementsUsingWar(Delta delta, Iterable<ContextElement<?>> iterable) {
        block3: {
            ContextWarModule contextWarModule;
            block2: {
                contextWarModule = (ContextWarModule)delta.getDeployed();
                logger.debug("Only a single war targeted to application context. All contextElements without a context will be associated with '{}'", (Object)contextWarModule.getContextRoot());
                if (delta.getOperation() != Operation.CREATE) break block2;
                for (ContextElement<?> contextElement : iterable) {
                    if (Strings.emptyToNull((String)contextElement.getContext()) != null) continue;
                    contextElement.setContext(contextWarModule.getContextRoot());
                }
                break block3;
            }
            if (delta.getPrevious() == null) break block3;
            ContextWarModule contextWarModule2 = (ContextWarModule)delta.getPrevious();
            for (ContextElement<?> contextElement : iterable) {
                if (!contextWarModule2.getContextRoot().equals(contextElement.getContext()) && Strings.emptyToNull((String)contextElement.getContext()) != null) continue;
                contextElement.setContext(contextWarModule.getContextRoot());
            }
        }
    }

    protected Iterable<ContextElement<?>> findAllContextElementsTargetedToApplicationContexts(List<Delta> list) {
        Iterable<AbstractDeployed<?>> iterable = Utils.findDeployedsTargetedToContainer(list, APPLICATION_CONTEXT_TYPE);
        return Utils.extractDeployedContextElements(iterable);
    }

    protected static Iterable<Delta> findContextWarModulesTargetedToVirtualHost(List<Delta> list) {
        return Iterables.filter(list, (Predicate)new Predicate<Delta>(){

            public boolean apply(Delta delta) {
                if (delta.getOperation() != Operation.DESTROY) {
                    return this.accept(delta.getDeployed());
                }
                return false;
            }

            private boolean accept(Deployed<?, ?> deployed) {
                return deployed != null && deployed.getContainer().getType().instanceOf(APPLICATION_CONTEXT_TYPE) && deployed instanceof ContextWarModule;
            }
        });
    }
}

