package com.xebialabs.deployit.plugin.trigger;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;

import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;

public enum TaskState implements TriggerState<TaskExecutionState> {
    ANY(null,null),
    QUEUED(TaskExecutionState.QUEUED, newHashSet(TaskExecutionState.EXECUTING)),
    PENDING(TaskExecutionState.PENDING, newHashSet(TaskExecutionState.EXECUTING, TaskExecutionState.QUEUED)),
    EXECUTING(TaskExecutionState.EXECUTING, newHashSet(TaskExecutionState.STOPPED,TaskExecutionState.EXECUTED)),
    DONE(TaskExecutionState.DONE, Sets.<TaskExecutionState>newHashSet()),
    STOPPED(TaskExecutionState.STOPPED, newHashSet(TaskExecutionState.EXECUTING,TaskExecutionState.CANCELLED)),
    EXECUTED(TaskExecutionState.EXECUTED, newHashSet(TaskExecutionState.DONE)),
    CANCELLED(TaskExecutionState.CANCELLED, Sets.<TaskExecutionState>newHashSet());

    private TaskExecutionState taskExecutionState;
    private Set<TaskExecutionState> validToTransition;

    private TaskState(TaskExecutionState taskExecutionState, Set<TaskExecutionState> validToTransition) {
        this.taskExecutionState = taskExecutionState;
        this.validToTransition = validToTransition;
    }

    public boolean equivalentTo(TaskExecutionState spiState) {
        if (spiState == null) {
            return false;
        }
        return (taskExecutionState == null) || (taskExecutionState == spiState);
    }

    public boolean isValidTransition(TaskState toState) {
        if (taskExecutionState == null || toState.taskExecutionState == null) {  //ANY state
            return true;
        }

        return validToTransition.contains(toState.taskExecutionState);
    }
}
